/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowIndex;

public final class WorkflowIndexService {
    private static final WorkflowIndexService instance = new WorkflowIndexService();
    private Map<String, WorkflowIndex> activeIndexes = new HashMap<String, WorkflowIndex>();

    public static WorkflowIndexService getInstance() {
        return instance;
    }

    private WorkflowIndexService() {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            DriverManager.getConnection("jdbc:derby:;shutdown=true");
                        }
                        catch (SQLException e) {
                            if (e.getErrorCode() == 45000) break block2;
                            e.printStackTrace();
                        }
                    }
                }
            }));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized WorkflowIndex getIndex(IProject project) {
        WorkflowIndex index = this.activeIndexes.get(project.getLocation().toPortableString());
        if (index != null) {
            return index;
        }
        index = new WorkflowIndex(project);
        this.activeIndexes.put(project.getLocation().toPortableString(), index);
        index.init();
        return index;
    }

    public synchronized void forgetIndex(IProject project) {
        this.activeIndexes.remove(project.getLocation().toPortableString());
    }

    public synchronized boolean isIndexed(IProject project) {
        WorkflowIndex index = this.activeIndexes.get(project.getLocation().toPortableString());
        if (index != null) {
            return true;
        }
        File dataDirectory = project.getWorkingLocation("org.eclipse.vtp.desktop.model.core").toFile();
        File indexDirectory = new File(dataDirectory, "index/");
        if (!indexDirectory.exists()) {
            return false;
        }
        try {
            Connection con = DriverManager.getConnection("jdbc:derby:" + indexDirectory.getAbsolutePath());
            con.close();
            return true;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }
}

