/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal.branding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;

public class Brand
implements IBrand {
    private String id;
    private String name;
    private Brand parentBrand;
    private List<Brand> childBrands;
    private BrandManager manager;

    public Brand(String id, String name) {
        this.id = id;
        this.name = name;
        this.childBrands = new ArrayList<Brand>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        if (newName.equals(this.name)) {
            return;
        }
        String oldName = this.name;
        this.name = newName;
        this.manager.fireBrandNameChanged(this, oldName);
    }

    @Override
    public IBrand getParent() {
        return this.parentBrand;
    }

    @Override
    public void setParent(IBrand ibrand) {
        if (!(ibrand instanceof Brand)) {
            throw new IllegalArgumentException("Parent must be a " + Brand.class.getName());
        }
        if (ibrand == this.parentBrand) {
            return;
        }
        Brand oldParent = this.parentBrand;
        Brand brand = (Brand)ibrand;
        this.checkParent(brand);
        this.parentBrand = brand;
        this.parentBrand.addChild(this);
        if (oldParent == null) {
            this.manager.fireBrandAdded(this);
        } else {
            this.manager.fireBrandParentChanged(this, oldParent);
        }
    }

    @Override
    public List<IBrand> getChildBrands() {
        return new ArrayList<IBrand>(this.childBrands);
    }

    protected void addChild(Brand child) {
        this.childBrands.remove(child);
        this.childBrands.add(child);
        child.setManager(this.manager);
    }

    protected void removeChild(Brand child) {
        this.childBrands.remove(child);
    }

    private void checkParent(Brand newParent) {
        if (newParent == null) {
            throw new IllegalArgumentException("Parent cannot be null");
        }
        int i = 0;
        while (i < this.childBrands.size()) {
            Brand child = this.childBrands.get(i);
            if (child.equals(newParent)) {
                throw new IllegalArgumentException("Circular reference detected in brand structure.");
            }
            child.checkParent(newParent);
            ++i;
        }
    }

    void setManager(BrandManager manager) {
        this.manager = manager;
    }

    @Override
    public void delete() {
        int i = 0;
        while (i < this.childBrands.size()) {
            IBrand child = this.childBrands.get(i);
            child.delete();
            ++i;
        }
        this.parentBrand.removeChild(this);
        this.manager.fireBrandRemoved(this);
    }
}

