/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal.design;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.model.core.design.IDesignComponent;
import org.eclipse.vtp.desktop.model.core.design.IDesignComponentListener;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnector;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.IDesignEntryPoint;
import org.eclipse.vtp.desktop.model.core.design.IDesignExitPoint;
import org.eclipse.vtp.desktop.model.core.design.IExitBroadcastReceiver;
import org.eclipse.vtp.desktop.model.core.design.ModelListener;
import org.eclipse.vtp.desktop.model.core.design.PaperSize;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowTraversalHelper;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignComponent;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignConnector;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignTraversalHelper;
import org.eclipse.vtp.framework.util.Guid;

public class Design
implements IDesign,
IDesignComponentListener {
    public static final String XML_VERSION = "1.0.0";
    private IDesignDocument document = null;
    private String id = null;
    private String name = null;
    private int orientation = 2;
    private PaperSize paperSize = null;
    private List<DesignElement> elements = new ArrayList<DesignElement>();
    private List<DesignConnector> connectors = new ArrayList<DesignConnector>();
    private List<ModelListener> listeners = new LinkedList<ModelListener>();

    public Design(String name) {
        this.id = Guid.createGUID();
        this.name = name;
    }

    public Design(String id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public String getDesignId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PaperSize getPaperSize() {
        return this.paperSize;
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    public void setDesignId(String id) {
        this.id = id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.fireNameChanged();
    }

    @Override
    public void setOrientation(int orientation) {
        if (orientation != 1 && orientation != 2) {
            throw new IllegalArgumentException("Canvas orientation must be one of IDesignConstants.PORTRAIT | IDesignConstants.LANDSCAPE");
        }
        this.orientation = orientation;
        this.fireOrientationChanged();
    }

    @Override
    public void setPaperSize(PaperSize paperSize) {
        this.paperSize = paperSize;
        this.firePaperSizeChanged();
    }

    @Override
    public int getWidth() {
        return this.orientation == 1 ? this.paperSize.getPortraitPixelWidth() : this.paperSize.getLandscapePixelWidth();
    }

    @Override
    public int getHeight() {
        return this.orientation == 1 ? this.paperSize.getPortraitPixelHeight() : this.paperSize.getLandscapePixelHeight();
    }

    @Override
    public IDesignDocument getDocument() {
        return this.document;
    }

    public void setDocument(IDesignDocument document) {
        this.document = document;
    }

    @Override
    public List<IDesignElement> getDesignElements() {
        LinkedList<IDesignElement> ret = new LinkedList<IDesignElement>();
        ret.addAll(this.elements);
        return ret;
    }

    @Override
    public List<IDesignConnector> getDesignConnectors() {
        LinkedList<IDesignConnector> ret = new LinkedList<IDesignConnector>();
        ret.addAll(this.connectors);
        return ret;
    }

    @Override
    public IDesignElement getDesignElement(String id) {
        int i = 0;
        while (i < this.elements.size()) {
            DesignElement e = this.elements.get(i);
            if (e.getId().equals(id)) {
                return e;
            }
            ++i;
        }
        return null;
    }

    public void forceNewIds() {
        this.id = Guid.createGUID();
        for (DesignElement element : this.elements) {
            element.setId(Guid.createGUID());
        }
        for (DesignConnector connector : this.connectors) {
            connector.setId(Guid.createGUID());
        }
    }

    public void validateModelStatus() {
        for (IDesignElement iDesignElement : this.elements) {
            ((DesignElement)iDesignElement).validateStatus();
        }
    }

    @Override
    public IDesignConnector getDesignConnector(String id) {
        int i = 0;
        while (i < this.connectors.size()) {
            DesignConnector c = this.connectors.get(i);
            if (c.getId().equals(id)) {
                return c;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void removeDesignElement(IDesignElement element) {
        List<IDesignElementConnectionPoint> conrecs = element.getConnectorRecords();
        for (IDesignElementConnectionPoint cr : conrecs) {
            if (cr.getDesignConnector() == null) continue;
            this.deleteComponent(cr.getDesignConnector());
        }
        List<IDesignConnector> inc = element.getIncomingConnectors();
        for (IDesignConnector con : inc) {
            this.deleteComponent(con);
        }
        this.deleteComponent(element);
    }

    @Override
    public void removeDesignConnector(IDesignConnector connector) {
        this.deleteComponent(connector);
    }

    private void deleteComponent(IDesignComponent component) {
        ((DesignComponent)component).delete();
    }

    @Override
    public void addDesignElement(IDesignElement element) {
        this.addDesignElement(element, true);
    }

    public void addDesignElement(IDesignElement element, boolean resolve) {
        DesignElement de = (DesignElement)element;
        this.elements.remove(de);
        this.elements.add(de);
        de.setDesign(this);
        de.addListener(this);
        if (resolve) {
            de.resolve();
        }
        this.fireComponentAdded(de);
    }

    public void addDesignConnector(DesignConnector connector) {
        this.connectors.remove(connector);
        this.connectors.add(connector);
        connector.setDesign(this);
        connector.addListener(this);
        this.fireComponentAdded(connector);
    }

    @Override
    public IDesignConnector createDesignConnector(IDesignElement originElement, IDesignElement destinationElement) {
        DesignConnector dc = new DesignConnector((DesignElement)originElement, (DesignElement)destinationElement);
        if (originElement == destinationElement) {
            dc.addMidpoint(originElement.getCenterPoint().x + 80, originElement.getCenterPoint().y - 40);
            dc.addMidpoint(originElement.getCenterPoint().x + 80, originElement.getCenterPoint().y + 40);
            dc.getConnectorLabel().setPosition(1, 0, 0);
        }
        this.connectors.add(dc);
        dc.setDesign(this);
        dc.addListener(this);
        this.fireComponentAdded(dc);
        return dc;
    }

    @Override
    public void componentChanged(IDesignComponent component) {
    }

    @Override
    public void componentDeleted(IDesignComponent component) {
        if (component instanceof DesignConnector) {
            this.connectors.remove(component);
        } else {
            this.elements.remove(component);
        }
        this.fireComponentRemoved((DesignComponent)component);
    }

    @Override
    public void addListener(ModelListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ModelListener listener) {
        this.listeners.remove(listener);
    }

    private void fireComponentAdded(DesignComponent component) {
        for (ModelListener listener : this.listeners) {
            listener.componentAdded(this, component);
        }
    }

    private void fireComponentRemoved(DesignComponent component) {
        for (ModelListener listener : this.listeners) {
            listener.componentRemoved(this, component);
        }
    }

    private void fireOrientationChanged() {
        for (ModelListener listener : this.listeners) {
            listener.orientationChanged(this);
        }
    }

    private void firePaperSizeChanged() {
        for (ModelListener listener : this.listeners) {
            listener.paperSizeChanged(this);
        }
    }

    private void fireNameChanged() {
        for (ModelListener listener : this.listeners) {
            listener.nameChanged(this);
        }
    }

    @Override
    public List<Variable> getVariablesFor(IDesignElement designElement) {
        return this.getVariablesFor(designElement, false);
    }

    @Override
    public List<Variable> getVariablesFor(IDesignElement designElement, boolean localOnly) {
        HashMap<String, DesignElement> visited = new HashMap<String, DesignElement>();
        String key = String.valueOf(designElement.getDesign().getDesignId()) + designElement.getId();
        visited.put(key, (DesignElement)designElement);
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        this.getVariablesFor0((DesignElement)designElement, visited, variables, localOnly);
        if (!localOnly) {
            System.err.println("not local only");
            ArrayList<IDesignDocument> workingCopies = new ArrayList<IDesignDocument>();
            workingCopies.add(this.getDocument());
            WorkflowTraversalHelper wth = new WorkflowTraversalHelper(this.getDocument().getProject(), workingCopies);
            List<IDesignEntryPoint> entryPoints = DesignTraversalHelper.getUpStreamDesignElements(designElement, IDesignEntryPoint.class);
            for (IDesignEntryPoint entryPoint : entryPoints) {
                System.out.println("found entry point: " + entryPoint.getId() + " " + entryPoint.getName());
            }
            List<IDesignExitPoint> exitPoints = wth.getUpStreamExitPoints(entryPoints);
            for (IDesignExitPoint exitPoint : exitPoints) {
                System.out.println("processing up stream exit points: " + exitPoint.getId() + " " + exitPoint.getTargetId() + " " + exitPoint.getTargetName());
                List<Variable> exitVars = exitPoint.getExportedDesignVariables();
                for (Variable v : exitVars) {
                    variables.put(v.getName(), v);
                }
            }
        }
        return new LinkedList<Variable>(variables.values());
    }

    private void getVariablesFor0(DesignElement designElement, Map<String, DesignElement> visited, Map<String, Variable> variables, boolean localOnly) {
        System.err.println("getting variables for: " + designElement.getName() + "[" + designElement.getId() + "]");
        List<IDesignConnector> incomingConnectors = designElement.getIncomingConnectors();
        for (IDesignConnector connector : incomingConnectors) {
            DesignElement sourceElement = (DesignElement)connector.getOrigin();
            String key = String.valueOf(sourceElement.getDesign().getDesignId()) + sourceElement.getId();
            if (visited.get(key) == null) {
                visited.put(key, sourceElement);
                this.getVariablesFor0(sourceElement, visited, variables, localOnly);
            }
            List<IDesignElementConnectionPoint> connectionPoints = connector.getConnectionPoints();
            for (IDesignElementConnectionPoint connectionPoint : connectionPoints) {
                List<Variable> exportedVariables = sourceElement.getOutgoingVariables(connectionPoint.getName(), localOnly);
                for (Variable var : exportedVariables) {
                    variables.put(var.getName(), var);
                }
            }
        }
        List<IExitBroadcastReceiver> receivers = designElement.getExitBroadcastReceivers();
        if (!receivers.isEmpty()) {
            System.err.println("has receivers");
            for (IDesignElement de : designElement.getDesign().getDesignElements()) {
                if (de == designElement) continue;
                for (IDesignElementConnectionPoint point : de.getConnectorRecords()) {
                    if (point.getDesignConnector() != null) continue;
                    System.err.println("empty connector: " + point.getName());
                    for (IExitBroadcastReceiver receiver : receivers) {
                        if (!point.getName().equals(receiver.getExitPattern())) continue;
                        System.err.println("found matching receiver");
                        System.err.println("design element: " + de.getName() + " [" + de.getId() + "]");
                        String key = String.valueOf(de.getDesign().getDesignId()) + de.getId();
                        if (visited.get(key) == null) {
                            visited.put(key, (DesignElement)de);
                            this.getVariablesFor0((DesignElement)de, visited, variables, localOnly);
                        }
                        List<Variable> exportedVariables = de.getOutgoingVariables(point.getName(), localOnly);
                        for (Variable var : exportedVariables) {
                            variables.put(var.getName(), var);
                        }
                    }
                }
            }
        }
    }

    @Override
    public List<Variable> getVariablesFrom(IDesignElement designElement, String exit) {
        return this.getVariablesFrom(designElement, exit, false);
    }

    @Override
    public List<Variable> getVariablesFrom(IDesignElement designElement, String exit, boolean localOnly) {
        List<Variable> variables = this.getVariablesFor(designElement, localOnly);
        List<Variable> elementVariables = designElement.getOutgoingVariables(exit);
        for (Variable v : elementVariables) {
            for (Variable v1 : variables) {
                if (v1.getName().equals(v.getName())) break;
            }
            variables.add(v);
        }
        return variables;
    }
}

