/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal.design;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnector;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnectorLabel;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnectorMidpoint;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorListener;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignComponent;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.w3c.dom.Element;

public class DesignConnector
extends DesignComponent
implements IDesignConnector {
    private DesignElement origin;
    private DesignElement destination;
    protected List<ConnectorRecord> exitCodes = new ArrayList<ConnectorRecord>();
    private List<ConnectorListener> listeners = new ArrayList<ConnectorListener>();
    private List<GraphPoint> points = new ArrayList<GraphPoint>();
    LineLabel label = null;

    public DesignConnector(DesignElement origin, DesignElement destination) {
        this.origin = origin;
        this.destination = destination;
        destination.addIncomingConnector(this);
        this.points.add(new ConnectorEndPoint(origin));
        this.points.add(new ConnectorEndPoint(destination));
        this.label = new LineLabel();
    }

    public DesignConnector(String id, DesignElement origin, DesignElement destination) {
        super(id);
        this.origin = origin;
        this.destination = destination;
        destination.addIncomingConnector(this);
        this.points.add(new ConnectorEndPoint(origin));
        this.points.add(new ConnectorEndPoint(destination));
        this.label = new LineLabel();
    }

    public void writeConfiguration(Element configuration) {
        Element connectorElement = configuration.getOwnerDocument().createElement("connector");
        configuration.appendChild(connectorElement);
        connectorElement.setAttribute("id", this.getId());
        connectorElement.setAttribute("origin", this.origin.getId());
        connectorElement.setAttribute("destination", this.destination.getId());
        for (ConnectorRecord cr : this.exitCodes) {
            Element recordElement = connectorElement.getOwnerDocument().createElement("record");
            connectorElement.appendChild(recordElement);
            recordElement.setAttribute("sourcename", cr.getName());
            recordElement.setAttribute("destinationname", "");
        }
    }

    public void setDestination(DesignElement destination) {
        this.destination = destination;
        this.fireChange();
    }

    public void setOrigin(DesignElement origin) {
        this.origin = origin;
        this.fireChange();
    }

    @Override
    public void addConnectionPoint(IDesignElementConnectionPoint record) {
        if (record != null) {
            ConnectorRecord record2 = (ConnectorRecord)record;
            record2.setConnector(this);
            this.exitCodes.add(record2);
            this.fireExitAdded(record2);
        }
        this.fireChange();
    }

    @Override
    public void removeConnectionPoint(IDesignElementConnectionPoint record) {
        ConnectorRecord record2 = (ConnectorRecord)record;
        record2.setConnector(null);
        this.exitCodes.remove(record);
        this.fireChange();
        this.fireExitRemoved(record2);
    }

    @Override
    public List<IDesignElementConnectionPoint> getConnectionPoints() {
        return new LinkedList<IDesignElementConnectionPoint>(this.exitCodes);
    }

    @Override
    public void clearConnectionPoints() {
        List<ConnectorRecord> oldExits = this.exitCodes;
        this.exitCodes = new ArrayList<ConnectorRecord>();
        for (ConnectorRecord cr : oldExits) {
            cr.setConnector(null);
            this.fireExitRemoved(cr);
        }
    }

    @Override
    public DesignElement getDestination() {
        return this.destination;
    }

    @Override
    public DesignElement getOrigin() {
        return this.origin;
    }

    @Override
    protected void delete() {
        this.clearConnectionPoints();
        this.destination.removeIncomingConnector(this);
        super.delete();
    }

    @Override
    public IDesignConnectorLabel getConnectorLabel() {
        return this.label;
    }

    @Override
    public Point[] getPoints() {
        Point[] ps = new Point[this.points.size()];
        int i = 0;
        while (i < this.points.size()) {
            ps[i] = i == this.points.size() - 1 ? this.points.get(i).getPoint(this.points.get(i - 1).getRegistryPoint()) : this.points.get(i).getPoint(this.points.get(i + 1).getRegistryPoint());
            if (ps[i] == null) {
                ps[i] = this.points.get(i).getRegistryPoint();
            }
            ++i;
        }
        return ps;
    }

    @Override
    public List<IDesignConnectorMidpoint> getMidpoints() {
        List<GraphPoint> midpoints = this.points.subList(1, this.points.size() - 1);
        return new LinkedList<GraphPoint>(midpoints);
    }

    @Override
    public IDesignConnectorMidpoint addMidpoint(int x, int y) {
        MidPoint midPoint = new MidPoint(x, y);
        this.points.add(this.points.size() - 1, midPoint);
        this.fireChange();
        return midPoint;
    }

    @Override
    public IDesignConnectorMidpoint insertMidpoint(int index, int x, int y) {
        MidPoint midPoint = new MidPoint(x, y);
        this.points.add(index, midPoint);
        this.fireChange();
        return midPoint;
    }

    @Override
    public void removeMidpoint(int index) {
        this.points.remove(index);
        this.fireChange();
    }

    @Override
    public void removeMidpoint(IDesignConnectorMidpoint midpoint) {
        this.points.remove(midpoint);
    }

    public void addConnectorListener(ConnectorListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeConnectorListener(ConnectorListener listener) {
        this.listeners.remove(listener);
    }

    private void fireExitAdded(ConnectorRecord cr) {
        for (ConnectorListener listener : this.listeners) {
            listener.exitPointAdded(cr);
        }
    }

    private void fireExitRemoved(ConnectorRecord cr) {
        for (ConnectorListener listener : this.listeners) {
            listener.exitPointRemoved(cr);
        }
    }

    public class ConnectorEndPoint
    implements GraphPoint {
        DesignElement terminus;

        public ConnectorEndPoint(DesignElement terminus) {
            this.terminus = terminus;
        }

        @Override
        public Point getPoint(Point originPoint) {
            return this.terminus.getCenterPoint();
        }

        @Override
        public Point getRegistryPoint() {
            return this.terminus.getCenterPoint();
        }

        @Override
        public void adjustPosition(int xoff, int yoff) {
        }
    }

    public static interface GraphPoint {
        public Point getPoint(Point var1);

        public Point getRegistryPoint();

        public void adjustPosition(int var1, int var2);
    }

    public class LineLabel
    implements IDesignConnectorLabel {
        private int lox = 0;
        private int loy = 0;
        private int linePointIndex = 0;

        @Override
        public void setPosition(int segment, int lox, int loy) {
            Point[] points = DesignConnector.this.getPoints();
            if (segment < 0 || segment >= points.length - 1) {
                segment = 0;
                lox = 0;
                loy = 0;
            }
            this.linePointIndex = segment;
            this.lox = lox;
            this.loy = loy;
        }

        @Override
        public void adjustPosition(int xoff, int yoff) {
            this.lox += xoff;
            this.loy += yoff;
        }

        @Override
        public void resetPosition() {
            this.linePointIndex = 0;
            this.lox = 0;
            this.loy = 0;
        }

        @Override
        public int getAnchorSegment() {
            return this.linePointIndex;
        }

        @Override
        public Point getOffsetPosition() {
            return new Point(this.lox, this.loy);
        }
    }

    public class MidPoint
    implements GraphPoint,
    IDesignConnectorMidpoint {
        int mx = 0;
        int my = 0;

        public MidPoint(int x, int y) {
            this.mx = x;
            this.my = y;
        }

        @Override
        public Point getPoint(Point originPoint) {
            return new Point(this.mx, this.my);
        }

        @Override
        public Point getRegistryPoint() {
            return new Point(this.mx, this.my);
        }

        @Override
        public void adjustPosition(int xoff, int yoff) {
            this.mx += xoff;
            this.my += yoff;
        }

        @Override
        public Point getPosition() {
            return this.getRegistryPoint();
        }

        @Override
        public void setPosition(int x, int y) {
            this.mx = x;
            this.my = y;
        }
    }
}

