/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal.design;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnector;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.IExitBroadcastReceiver;
import org.eclipse.vtp.desktop.model.core.internal.design.Design;

public class DesignTraversalHelper {
    public static <T> List<T> getDesignElements(Design design, Class<T> type) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (IDesignElement designElement : design.getDesignElements()) {
            Object object = designElement.getAdapter(type);
            if (object == null) continue;
            ret.add(object);
        }
        return ret;
    }

    public static <T> List<T> getUpStreamDesignElements(IDesignElement startElement, Class<T> destinationType) {
        ArrayList ret = new ArrayList();
        HashMap<String, IDesignElement> visited = new HashMap<String, IDesignElement>();
        visited.put(startElement.getId(), startElement);
        DesignTraversalHelper.getUpStreamDesignElements0(startElement, destinationType, ret, visited);
        return ret;
    }

    private static <T> void getUpStreamDesignElements0(IDesignElement startElement, Class<T> destinationType, List<T> elements, Map<String, IDesignElement> visited) {
        List<IExitBroadcastReceiver> receivers;
        List<IDesignConnector> connectors = startElement.getIncomingConnectors();
        for (IDesignConnector connector : connectors) {
            IDesignElement sourceElement = connector.getOrigin();
            Object adapter = sourceElement.getAdapter(destinationType);
            if (adapter != null) {
                elements.add(adapter);
            }
            if (visited.get(sourceElement.getId()) != null) continue;
            visited.put(sourceElement.getId(), sourceElement);
            DesignTraversalHelper.getUpStreamDesignElements0(sourceElement, destinationType, elements, visited);
        }
        if (startElement.getDesign() == startElement.getDesign().getDocument().getMainDesign() && !(receivers = startElement.getExitBroadcastReceivers()).isEmpty()) {
            for (IDesignElement sourceElement : startElement.getDesign().getDesignElements()) {
                for (IDesignElementConnectionPoint point : sourceElement.getConnectorRecords()) {
                    if (point.getDesignConnector() != null) continue;
                    for (IExitBroadcastReceiver receiver : receivers) {
                        if (!point.getName().equals(receiver.getExitPattern())) continue;
                        Object adapter = sourceElement.getAdapter(destinationType);
                        if (adapter != null) {
                            elements.add(adapter);
                        }
                        if (visited.get(sourceElement.getId()) != null) continue;
                        visited.put(sourceElement.getId(), sourceElement);
                        DesignTraversalHelper.getUpStreamDesignElements0(sourceElement, destinationType, elements, visited);
                    }
                }
            }
        }
    }

    public static <T> List<T> getDownStreamDesignElements(IDesignElement startElement, Class<T> destinationType) {
        ArrayList ret = new ArrayList();
        HashMap<String, IDesignElement> visited = new HashMap<String, IDesignElement>();
        visited.put(startElement.getId(), startElement);
        DesignTraversalHelper.getDownStreamDesignElements0(startElement, destinationType, ret, visited);
        return ret;
    }

    private static <T> void getDownStreamDesignElements0(IDesignElement startElement, Class<T> destinationType, List<T> elements, Map<String, IDesignElement> visited) {
        List<IDesignElementConnectionPoint> records = startElement.getConnectorRecords();
        for (IDesignElementConnectionPoint connectionPoint : records) {
            IDesignConnector connector = connectionPoint.getDesignConnector();
            if (connector != null) {
                IDesignElement targetElement = connector.getDestination();
                Object adapter = targetElement.getAdapter(destinationType);
                if (adapter != null) {
                    elements.add(adapter);
                }
                if (visited.get(targetElement.getId()) != null) continue;
                visited.put(targetElement.getId(), targetElement);
                DesignTraversalHelper.getDownStreamDesignElements0(targetElement, destinationType, elements, visited);
                continue;
            }
            if (startElement.getDesign() != startElement.getDesign().getDocument().getMainDesign()) continue;
            block1: for (IDesignElement targetElement : startElement.getDesign().getDesignElements()) {
                for (IExitBroadcastReceiver receiver : targetElement.getExitBroadcastReceivers()) {
                    if (!connectionPoint.getName().equals(receiver.getExitPattern())) continue;
                    Object adapter = targetElement.getAdapter(destinationType);
                    if (adapter != null) {
                        elements.add(adapter);
                    }
                    if (visited.get(targetElement.getId()) != null) continue block1;
                    visited.put(targetElement.getId(), targetElement);
                    DesignTraversalHelper.getDownStreamDesignElements0(targetElement, destinationType, elements, visited);
                    continue block1;
                }
            }
        }
    }
}

