/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal.design;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.osgi.framework.Bundle;

public class ElementManager {
    public static final String elementTypeExtensionId = "org.eclipse.vtp.desktop.model.core.elementType";
    private static final ElementManager INSTANCE = new ElementManager();
    private Map<String, ReaderRecord> elementTypes = new HashMap<String, ReaderRecord>();

    public static ElementManager getInstance() {
        return INSTANCE;
    }

    public ElementManager() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(elementTypeExtensionId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            block3: {
                ReaderRecord rr = new ReaderRecord();
                rr.type = primitiveExtensions[i].getAttribute("id");
                String className = primitiveExtensions[i].getAttribute("class");
                Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
                try {
                    rr.elementClass = contributor.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    break block3;
                }
                this.elementTypes.put(rr.type, rr);
            }
            ++i;
        }
    }

    public DesignElement loadElement(String elementTypeId, String id, String name, Properties properties) {
        ReaderRecord rr = this.elementTypes.get(elementTypeId);
        try {
            Constructor<DesignElement> constructor = rr.elementClass.getConstructor(String.class, String.class, Properties.class);
            return constructor.newInstance(id, name, properties);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private class ReaderRecord {
        String type;
        Class<DesignElement> elementClass;

        private ReaderRecord() {
        }
    }
}

