/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.schema;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.desktop.model.core.schema.AttributeGrouping;
import org.eclipse.vtp.desktop.model.core.schema.AttributeItem;
import org.eclipse.vtp.desktop.model.core.schema.AttributeItemContainer;
import org.eclipse.vtp.desktop.model.core.schema.ComplexContentModel;
import org.eclipse.vtp.desktop.model.core.schema.ComplexType;
import org.eclipse.vtp.desktop.model.core.schema.ElementGroup;
import org.eclipse.vtp.desktop.model.core.schema.ElementGroupReference;
import org.eclipse.vtp.desktop.model.core.schema.ElementGrouping;
import org.eclipse.vtp.desktop.model.core.schema.ElementItem;
import org.eclipse.vtp.desktop.model.core.schema.ElementItemReference;
import org.eclipse.vtp.desktop.model.core.schema.ExtendedComplexContentModel;
import org.eclipse.vtp.desktop.model.core.schema.RestrictedComplexContentModel;
import org.eclipse.vtp.desktop.model.core.schema.SchemaProblem;
import org.eclipse.vtp.desktop.model.core.schema.SimpleContentModel;
import org.eclipse.vtp.desktop.model.core.schema.SimpleType;
import org.eclipse.vtp.desktop.model.core.schema.Type;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Schema {
    public static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final Schema DEFAULT_SCHEMA = new Schema();
    private String targetNamespace = null;
    private boolean qualifyElements = false;
    private boolean qualifyAttributes = false;
    private Map<String, Schema> schemasByNamespace = new HashMap<String, Schema>();
    private Map<String, Type> localTypesByName = new HashMap<String, Type>();
    private Map<String, ElementItem> globalElementsByName = new HashMap<String, ElementItem>();
    private Map<String, AttributeItem> globalAttributesByName = new HashMap<String, AttributeItem>();
    private Map<String, AttributeGrouping> globalAttributeGroupsByName = new HashMap<String, AttributeGrouping>();
    private Map<String, ElementGrouping> globalElementGroupsByName = new HashMap<String, ElementGrouping>();
    private List<SchemaProblem> problems = new LinkedList<SchemaProblem>();

    protected Schema() {
        this.targetNamespace = SCHEMA_NAMESPACE;
        this.qualifyElements = false;
        this.qualifyAttributes = false;
        this.localTypesByName.put("anySimpleType", new SimpleType(this, "anySimpleType"));
        this.localTypesByName.put("duration", new SimpleType(this, "duration"));
        this.localTypesByName.put("dateTime", new SimpleType(this, "dateTime"));
        this.localTypesByName.put("time", new SimpleType(this, "time"));
        this.localTypesByName.put("date", new SimpleType(this, "date"));
        this.localTypesByName.put("gYearMonth", new SimpleType(this, "gYearMonth"));
        this.localTypesByName.put("gYear", new SimpleType(this, "gYear"));
        this.localTypesByName.put("gMonthDay", new SimpleType(this, "gMonthDay"));
        this.localTypesByName.put("gDay", new SimpleType(this, "gDay"));
        this.localTypesByName.put("gMonth", new SimpleType(this, "gMonth"));
        this.localTypesByName.put("boolean", new SimpleType(this, "boolean"));
        this.localTypesByName.put("base64Binary", new SimpleType(this, "base64Binary"));
        this.localTypesByName.put("hexBinary", new SimpleType(this, "hexBinary"));
        this.localTypesByName.put("float", new SimpleType(this, "float"));
        this.localTypesByName.put("double", new SimpleType(this, "double"));
        this.localTypesByName.put("anyURI", new SimpleType(this, "anyURI"));
        this.localTypesByName.put("QName", new SimpleType(this, "QName"));
        this.localTypesByName.put("NOTATION", new SimpleType(this, "NOTATION"));
        this.localTypesByName.put("string", new SimpleType(this, "string"));
        this.localTypesByName.put("decimal", new SimpleType(this, "decimal"));
        this.localTypesByName.put("normalizedString", new SimpleType(this, "normalizedString"));
        this.localTypesByName.put("token", new SimpleType(this, "token"));
        this.localTypesByName.put("language", new SimpleType(this, "language"));
        this.localTypesByName.put("Name", new SimpleType(this, "Name"));
        this.localTypesByName.put("NMTOKEN", new SimpleType(this, "NMTOKEN"));
        this.localTypesByName.put("NCName", new SimpleType(this, "NCName"));
        this.localTypesByName.put("ID", new SimpleType(this, "ID"));
        this.localTypesByName.put("IDREF", new SimpleType(this, "IDREF"));
        this.localTypesByName.put("ENTITY", new SimpleType(this, "ENTITY"));
        this.localTypesByName.put("integer", new SimpleType(this, "integer"));
        this.localTypesByName.put("nonPositiveInteger", new SimpleType(this, "nonPositiveInteger"));
        this.localTypesByName.put("long", new SimpleType(this, "long"));
        this.localTypesByName.put("nonNegativeInteger", new SimpleType(this, "nonNegativeInteger"));
        this.localTypesByName.put("negativeInteger", new SimpleType(this, "negativeInteger"));
        this.localTypesByName.put("int", new SimpleType(this, "int"));
        this.localTypesByName.put("unsignedLong", new SimpleType(this, "unsignedLong"));
        this.localTypesByName.put("positiveInteger", new SimpleType(this, "positiveInteger"));
        this.localTypesByName.put("short", new SimpleType(this, "short"));
        this.localTypesByName.put("unsignedInt", new SimpleType(this, "unsignedInt"));
        this.localTypesByName.put("byte", new SimpleType(this, "byte"));
        this.localTypesByName.put("unsignedShort", new SimpleType(this, "unsignedShort"));
        this.localTypesByName.put("unsignedByte", new SimpleType(this, "unsignedByte"));
        this.localTypesByName.put("NMTOKENS", new SimpleType(this, "NMTOKENS"));
        this.localTypesByName.put("IDREFS", new SimpleType(this, "IDREFS"));
        this.localTypesByName.put("ENTITIES", new SimpleType(this, "ENTITIES"));
        ComplexType anyType = new ComplexType(this, "anyType");
        anyType.setContentModel(new ComplexContentModel(true));
        this.localTypesByName.put("anyType", anyType);
    }

    /*
     * Unable to fully structure code
     */
    public Schema(Element schemaElement) {
        super();
        this.addSchema(new Schema());
        problemCollector = new LinkedList<SchemaProblem>();
        this.targetNamespace = schemaElement.getAttribute("targetNamespace");
        this.qualifyElements = schemaElement.getAttribute("elementFormDefault").equals("qualified");
        this.qualifyAttributes = schemaElement.getAttribute("attributeFormDefault").equals("qualified");
        redefines = XMLUtilities.getElementsByTagNameNS((Element)schemaElement, (String)"http://www.w3.org/2001/XMLSchema", (String)"redefine", (boolean)true);
        if (redefines.size() > 0) {
            for (Element redefineElement : redefines) {
                problemCollector.add(this.createProblem("The redefine schema feature is not supported by this parser.", redefineElement));
            }
        }
        imports = XMLUtilities.getElementsByTagNameNS((Element)schemaElement, (String)"http://www.w3.org/2001/XMLSchema", (String)"import", (boolean)true);
        i = 0;
        while (i < imports.size()) {
            block29: {
                block30: {
                    namespaceAttr = ((Element)imports.get(i)).getAttributeNode("namespace");
                    if (namespaceAttr != null && this.schemasByNamespace.get(namespaceAttr.getValue()) != null) break block29;
                    locationUri = null;
                    locationAttr = ((Element)imports.get(i)).getAttributeNode("schemaLocation");
                    if (locationAttr == null) break block30;
                    locationUri = locationAttr.getValue();
                    ** GOTO lbl39
                }
                if (namespaceAttr == null) {
                    problemCollector.add(this.createProblem("Unable to import schema", (Element)imports.get(i)));
                } else {
                    locationUri = namespaceAttr.getValue();
lbl39:
                    // 2 sources

                    try {
                        url = new URL(locationUri);
                        con = url.openConnection();
                        in = con.getInputStream();
                        try {
                            factory = DocumentBuilderFactory.newInstance();
                            factory.setNamespaceAware(true);
                            builder = factory.newDocumentBuilder();
                            document = builder.parse(in);
                            rootElement = document.getDocumentElement();
                            schema = new Schema(rootElement);
                            if (schema.getProblems().size() > 0) {
                                problemCollector.add(this.createProblem("Unable to import schema location: " + locationUri, (Element)imports.get(i)));
                            } else {
                                this.schemasByNamespace.put(schema.targetNamespace, schema);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            problemCollector.add(this.createProblem("Unable to import schema location: " + locationUri, (Element)imports.get(i), ex));
                        }
                        in.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        problemCollector.add(this.createProblem("Unable to import schema location: " + locationUri, (Element)imports.get(i), e));
                    }
                }
            }
            ++i;
        }
        processList = XMLUtilities.getElementsByTagNameNS((Element)schemaElement, (String)"http://www.w3.org/2001/XMLSchema", (String)"simpleType", (boolean)true);
        numResolved = 0;
        do {
            this.setProblems(new LinkedList<SchemaProblem>());
            numResolved = 0;
            iterator = processList.iterator();
            while (iterator.hasNext()) {
                simpleType = this.parseSimpleType((Element)iterator.next());
                if (simpleType == null) continue;
                this.localTypesByName.put(simpleType.getName(), simpleType);
                iterator.remove();
                ++numResolved;
            }
        } while (processList.size() > 0 && numResolved > 0);
        if (processList.size() > 0) {
            problemCollector.addAll(this.getProblems());
        }
        this.setProblems(new LinkedList<SchemaProblem>());
        attributeItemElementList = XMLUtilities.getElementsByTagNameNS((Element)schemaElement, (String)"http://www.w3.org/2001/XMLSchema", (String)"attribute", (boolean)true);
        i = 0;
        while (i < attributeItemElementList.size()) {
            attributeItemElement = (Element)attributeItemElementList.get(i);
            System.out.println("parsing global attribute: " + attributeItemElement.getAttribute("name"));
            attributeItem = this.parseAttributeItem(attributeItemElement);
            this.globalAttributesByName.put(attributeItem.getName(), attributeItem);
            ++i;
        }
        problemCollector.addAll(this.getProblems());
        processList = XMLUtilities.getElementsByTagNameNS((Element)schemaElement, (String)"http://www.w3.org/2001/XMLSchema", (String)"attributeGroup", (boolean)true);
        numResolved = 0;
        do {
            this.setProblems(new LinkedList<SchemaProblem>());
            numResolved = 0;
            iterator = processList.iterator();
            while (iterator.hasNext()) {
                attributeGroupElement = (Element)iterator.next();
                attributeGrouping = new AttributeGrouping(this, attributeGroupElement.getAttribute("name"));
                if (!this.parseAttributeObjects(attributeGrouping, attributeGroupElement)) continue;
                this.globalAttributeGroupsByName.put(attributeGrouping.getName(), attributeGrouping);
                iterator.remove();
                ++numResolved;
            }
        } while (processList.size() > 0 && numResolved > 0);
        if (processList.size() > 0) {
            problemCollector.addAll(this.getProblems());
        }
        elementItemElementList = XMLUtilities.getElementsByTagNameNS((Element)schemaElement, (String)"http://www.w3.org/2001/XMLSchema", (String)"element", (boolean)true);
        i = 0;
        while (i < elementItemElementList.size()) {
            elementItemElement = (Element)elementItemElementList.get(i);
            elementItem = new ElementItem(this, elementItemElement.getAttribute("name"));
            this.globalElementsByName.put(elementItem.getName(), elementItem);
            ++i;
        }
        this.setProblems(new LinkedList<SchemaProblem>());
        elementGroupElementList = XMLUtilities.getElementsByTagNameNS((Element)schemaElement, (String)"http://www.w3.org/2001/XMLSchema", (String)"group", (boolean)true);
        i = 0;
        while (i < elementGroupElementList.size()) {
            elementGroupElement = (Element)elementGroupElementList.get(i);
            elementGrouping = new ElementGrouping(this, elementGroupElement.getAttribute("name"));
            childList = elementGroupElement.getChildNodes();
            c = 0;
            while (c < childList.getLength()) {
                if (childList.item(c).getNodeType() == 1 && !(element = (Element)childList.item(c)).getLocalName().equals("annotation") && (eg = this.parseElementGroup(element)) != null) {
                    elementGrouping.setElementGroup(eg);
                }
                ++c;
            }
            this.globalElementGroupsByName.put(elementGrouping.getName(), elementGrouping);
            ++i;
        }
        problemCollector.addAll(this.getProblems());
        processList = XMLUtilities.getElementsByTagNameNS((Element)schemaElement, (String)"http://www.w3.org/2001/XMLSchema", (String)"complexType", (boolean)true);
        numResolved = 0;
        do {
            this.setProblems(new LinkedList<SchemaProblem>());
            numResolved = 0;
            iterator = processList.iterator();
            while (iterator.hasNext()) {
                complexTypeElement = (Element)iterator.next();
                complexType = new ComplexType(this, complexTypeElement.getAttribute("name"));
                this.localTypesByName.put(complexType.getName(), complexType);
                System.out.println("Attempting to resolve global complex type: " + complexType.getName());
                if (this.populateComplexType(complexType, complexTypeElement)) {
                    System.out.println("resolved complex type");
                    iterator.remove();
                    ++numResolved;
                    continue;
                }
                System.out.println("failed to resolve complex type");
                this.localTypesByName.remove(complexType.getName());
            }
        } while (processList.size() > 0 && numResolved > 0);
        if (processList.size() > 0) {
            System.out.println(((Element)processList.get(0)).getAttribute("name"));
            problemCollector.addAll(this.getProblems());
        }
        this.setProblems(new LinkedList<SchemaProblem>());
        i = 0;
        while (i < elementItemElementList.size()) {
            elementItemElement = (Element)elementItemElementList.get(i);
            elementItem = this.globalElementsByName.get(elementItemElement.getAttribute("name"));
            if (elementItem == null) {
                throw new RuntimeException("Could not locate global element to populate: " + elementItemElement);
            }
            System.out.println("populating global element: " + elementItem.getName());
            if (!this.populateElementItem(elementItemElement, elementItem)) {
                // empty if block
            }
            ++i;
        }
        problemCollector.addAll(this.getProblems());
        this.setProblems(problemCollector);
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    private void addProblem(SchemaProblem problem) {
        this.problems.add(problem);
    }

    private void setProblems(List<SchemaProblem> problems) {
        this.problems = problems;
    }

    public List<SchemaProblem> getProblems() {
        return new LinkedList<SchemaProblem>(this.problems);
    }

    public SimpleType parseSimpleType(Element simpleTypeElement) {
        String name = simpleTypeElement.getAttribute("name");
        SimpleType simpleType = new SimpleType(this, name);
        NodeList restrictionElementList = simpleTypeElement.getElementsByTagNameNS(SCHEMA_NAMESPACE, "restriction");
        if (restrictionElementList.getLength() > 0) {
            Element restrictionElement = (Element)restrictionElementList.item(0);
            SimpleType baseType = null;
            String base = restrictionElement.getAttribute("base");
            System.out.println("base type: " + base);
            if (!base.equals("")) {
                baseType = (SimpleType)this.resolveType(restrictionElement, base);
            } else {
                NodeList recurseSimpleTypeElementList = restrictionElement.getElementsByTagNameNS(SCHEMA_NAMESPACE, "simpleType");
                if (recurseSimpleTypeElementList.getLength() > 0) {
                    baseType = this.parseSimpleType((Element)recurseSimpleTypeElementList.item(0));
                }
            }
            if (baseType == null) {
                this.addProblem(this.createProblem("Unable to parse simple type '" + name + "': base type '" + base + "' not found or invalid", simpleTypeElement));
                return null;
            }
            return simpleType;
        }
        this.addProblem(this.createProblem("Unsupported simple type mechanism.", simpleTypeElement));
        return null;
    }

    public ComplexType parseComplexType(Element complexTypeElement) {
        String name = complexTypeElement.getAttribute("name");
        ComplexType complexType = new ComplexType(this, name);
        if (!this.populateComplexType(complexType, complexTypeElement)) {
            return null;
        }
        return complexType;
    }

    /*
     * Unable to fully structure code
     */
    public boolean populateComplexType(ComplexType complexType, Element complexTypeElement) {
        block30: {
            block28: {
                block31: {
                    block29: {
                        simpleContentElementList = XMLUtilities.getElementsByTagNameNS((Element)complexTypeElement, (String)"http://www.w3.org/2001/XMLSchema", (String)"simpleContent", (boolean)true);
                        if (simpleContentElementList.size() <= 0) break block28;
                        simpleContentElement = (Element)simpleContentElementList.get(0);
                        simpleContent = new SimpleContentModel();
                        derivationElementList = simpleContentElement.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "restriction");
                        if (derivationElementList.getLength() <= 0) break block29;
                        restrictionElement = (Element)derivationElementList.item(0);
                        baseType = null;
                        base = restrictionElement.getAttribute("base");
                        if (!base.equals("")) {
                            baseType = (SimpleType)this.resolveType(restrictionElement, base);
                        }
                        if (baseType == null) {
                            this.addProblem(this.createProblem("Base type '" + base + "' not found or invalid.", restrictionElement));
                            return false;
                        }
                        if (!this.parseAttributeObjects(simpleContent, restrictionElement)) {
                            return false;
                        }
                        complexType.setContentModel(simpleContent);
                        break block30;
                    }
                    derivationElementList = simpleContentElement.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "extension");
                    if (derivationElementList.getLength() <= 0) break block31;
                    extensionElement = (Element)derivationElementList.item(0);
                    baseType = null;
                    base = extensionElement.getAttribute("base");
                    if (!base.equals("")) {
                        baseType = (SimpleType)this.resolveType(extensionElement, base);
                    }
                    if (baseType == null) {
                        this.addProblem(this.createProblem("Base type '" + base + "' not found or invalid.", extensionElement));
                        return false;
                    }
                    if (!this.parseAttributeObjects(simpleContent, extensionElement)) {
                        return false;
                    }
                    complexType.setContentModel(simpleContent);
                    break block30;
                }
                this.addProblem(this.createProblem("Type derivation method not supported.", simpleContentElement));
                return false;
            }
            complexContentElementList = XMLUtilities.getElementsByTagNameNS((Element)complexTypeElement, (String)"http://www.w3.org/2001/XMLSchema", (String)"complexContent", (boolean)true);
            if (complexContentElementList.size() <= 0) ** GOTO lbl92
            complexContentElement = (Element)complexContentElementList.get(0);
            mixed = complexContentElement.getAttribute("mixed");
            derivationElementList = complexContentElement.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "restriction");
            if (derivationElementList.getLength() > 0) {
                restrictionElement = (Element)derivationElementList.item(0);
                baseType = (ComplexType)this.resolveType(restrictionElement, base = restrictionElement.getAttribute("base"));
                if (baseType == null) {
                    this.addProblem(this.createProblem("Base type '" + base + "' not found or invalid.", restrictionElement));
                    return false;
                }
                restrictedModel = new RestrictedComplexContentModel(baseType);
                if (!mixed.equals("")) {
                    restrictedModel.setLocalMixedContent(Boolean.parseBoolean(mixed));
                }
                particleList = restrictionElement.getChildNodes();
                i = 0;
                while (i < particleList.getLength()) {
                    if (!(particleList.item(i).getNodeType() != 1 || (element = (Element)particleList.item(i)).getLocalName().equals("annotation") || element.getLocalName().equals("attributeGroup") || element.getLocalName().equals("attribute"))) {
                        eg = this.parseElementGroup(element);
                        if (eg == null) {
                            return false;
                        }
                        restrictedModel.setElementGroup(eg);
                    }
                    ++i;
                }
                if (!this.parseAttributeObjects(restrictedModel, restrictionElement)) {
                    return false;
                }
                complexType.setContentModel(restrictedModel);
            } else {
                derivationElementList = complexContentElement.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "extension");
                if (derivationElementList.getLength() > 0) {
                    extensionElement = (Element)derivationElementList.item(0);
                    baseType = (ComplexType)this.resolveType(extensionElement, base = extensionElement.getAttribute("base"));
                    if (baseType == null) {
                        this.addProblem(this.createProblem("Base type '" + base + "' not found or invalid.", extensionElement));
                        return false;
                    }
                    extendedModel = new ExtendedComplexContentModel(baseType);
                    if (!mixed.equals("")) {
                        extendedModel.setLocalMixedContent(Boolean.parseBoolean(mixed));
                    }
                    particleList = extensionElement.getChildNodes();
                    i = 0;
                    while (i < particleList.getLength()) {
                        if (!(particleList.item(i).getNodeType() != 1 || (element = (Element)particleList.item(i)).getLocalName().equals("annotation") || element.getLocalName().equals("attributeGroup") || element.getLocalName().equals("attribute"))) {
                            eg = this.parseElementGroup(element);
                            if (eg == null) {
                                return false;
                            }
                            extendedModel.setElementGroup(eg);
                        }
                        ++i;
                    }
                    if (!this.parseAttributeObjects(extendedModel, extensionElement)) {
                        return false;
                    }
                    complexType.setContentModel(extendedModel);
                } else {
                    this.addProblem(this.createProblem("Type derivation method not supported.", complexContentElement));
                    return false;
lbl92:
                    // 1 sources

                    mixed = complexTypeElement.getAttribute("mixed");
                    baseType = (ComplexType)this.resolveType("http://www.w3.org/2001/XMLSchema", "anyType");
                    if (baseType == null) {
                        this.addProblem(this.createProblem("Base type 'anyType' not found or invalid.", complexTypeElement));
                        return false;
                    }
                    restrictedModel = new RestrictedComplexContentModel(baseType);
                    if (!mixed.equals("")) {
                        restrictedModel.setLocalMixedContent(Boolean.parseBoolean(mixed));
                    }
                    particleList = complexTypeElement.getChildNodes();
                    i = 0;
                    while (i < particleList.getLength()) {
                        if (!(particleList.item(i).getNodeType() != 1 || (element = (Element)particleList.item(i)).getLocalName().equals("annotation") || element.getLocalName().equals("attributeGroup") || element.getLocalName().equals("attribute"))) {
                            eg = this.parseElementGroup(element);
                            if (eg == null) {
                                return false;
                            }
                            restrictedModel.setElementGroup(eg);
                            if (!this.parseAttributeObjects(restrictedModel, complexTypeElement)) {
                                return false;
                            }
                            complexType.setContentModel(restrictedModel);
                        }
                        ++i;
                    }
                }
            }
        }
        return true;
    }

    public boolean populateElementItem(Element elementItemElement, ElementItem item) {
        System.out.println("populating element: " + item.getName());
        Attr typeAttr = elementItemElement.getAttributeNode("type");
        if (typeAttr != null) {
            Type type = this.resolveType(elementItemElement, typeAttr.getValue());
            if (type == null) {
                this.addProblem(this.createProblem("Element type '" + typeAttr.getValue() + "' not found or invalid.", elementItemElement));
                return false;
            }
            item.setType(type);
        } else {
            NodeList simpleTypeList = elementItemElement.getElementsByTagNameNS(SCHEMA_NAMESPACE, "simpleType");
            if (simpleTypeList.getLength() > 0) {
                SimpleType type = this.parseSimpleType((Element)simpleTypeList.item(0));
                if (type == null) {
                    return false;
                }
                item.setType(type);
            } else {
                NodeList complexTypeList = elementItemElement.getElementsByTagNameNS(SCHEMA_NAMESPACE, "complexType");
                if (complexTypeList.getLength() > 0) {
                    ComplexType type = this.parseComplexType((Element)complexTypeList.item(0));
                    if (type == null) {
                        return false;
                    }
                    item.setType(type);
                } else {
                    item.setType(this.resolveType(SCHEMA_NAMESPACE, "anyType"));
                }
            }
        }
        return true;
    }

    public ElementGroup parseElementGroup(Element elementGroupElement) {
        Attr maxAttr;
        Attr minAttr;
        ElementGroup eg;
        block28: {
            System.out.println("parsing element group: " + elementGroupElement.getLocalName());
            eg = null;
            if (elementGroupElement.getLocalName().equals("sequence")) {
                eg = new ElementGroup(this, "sequence");
            } else if (elementGroupElement.getLocalName().equals("choice")) {
                eg = new ElementGroup(this, "choice");
            } else if (elementGroupElement.getLocalName().equals("all")) {
                eg = new ElementGroup(this, "all");
            } else {
                if (elementGroupElement.getLocalName().equals("any")) {
                    eg = new ElementGroup(this, "any");
                    return eg;
                }
                if (elementGroupElement.getLocalName().equals("group")) {
                    String ref = elementGroupElement.getAttribute("ref");
                    eg = new ElementGroupReference(this);
                    ElementGrouping elementGrouping = this.resolveElementGrouping(elementGroupElement, ref);
                    if (elementGrouping == null) {
                        this.addProblem(this.createProblem("Unable to resolve group reference: " + ref, elementGroupElement));
                        return null;
                    }
                    ((ElementGroupReference)eg).setReferencedElementGroup(elementGrouping);
                } else {
                    this.addProblem(this.createProblem("Unsupported element group tag.", elementGroupElement));
                    return null;
                }
            }
            minAttr = elementGroupElement.getAttributeNode("minOccurs");
            if (minAttr != null) {
                eg.setMinOccurs(Integer.parseInt(minAttr.getValue()));
            }
            if ((maxAttr = elementGroupElement.getAttributeNode("maxOccurs")) != null) {
                try {
                    eg.setMaxOccurs(Integer.parseInt(maxAttr.getValue()));
                }
                catch (NumberFormatException e) {
                    if (!maxAttr.getValue().equals("unbounded")) break block28;
                    eg.setMaxOccurs(Integer.MAX_VALUE);
                }
            }
        }
        NodeList children = elementGroupElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeType() == 1) {
                Element childElement = (Element)children.item(i);
                System.out.println("processing child element of group: " + childElement.getLocalName());
                if (!childElement.getLocalName().equals("annotation")) {
                    if (childElement.getLocalName().equals("element")) {
                        ElementItem item;
                        block29: {
                            item = null;
                            Attr refAttr = childElement.getAttributeNode("ref");
                            if (refAttr != null) {
                                ElementItem ei = this.resolveElementItem(childElement, refAttr.getValue());
                                if (ei == null) {
                                    this.addProblem(this.createProblem("Element reference could not be resolved.", childElement));
                                    return null;
                                }
                                ElementItemReference eir = new ElementItemReference(this);
                                eir.setReferencedElementItem(ei);
                                item = eir;
                            } else {
                                String name = childElement.getAttribute("name");
                                ElementItem ei = new ElementItem(this, name);
                                if (!this.populateElementItem(childElement, ei)) {
                                    return null;
                                }
                                item = ei;
                            }
                            minAttr = childElement.getAttributeNode("minOccurs");
                            if (minAttr != null) {
                                item.setMinOccurs(Integer.parseInt(minAttr.getValue()));
                            }
                            if ((maxAttr = childElement.getAttributeNode("maxOccurs")) != null) {
                                try {
                                    item.setMaxOccurs(Integer.parseInt(maxAttr.getValue()));
                                }
                                catch (NumberFormatException e) {
                                    if (!maxAttr.getValue().equals("unbounded")) break block29;
                                    item.setMaxOccurs(Integer.MAX_VALUE);
                                }
                            }
                        }
                        eg.addElementObject(item);
                    } else {
                        ElementGroup childGroup = this.parseElementGroup(childElement);
                        if (childGroup == null) {
                            return null;
                        }
                        eg.addElementObject(childGroup);
                    }
                }
            }
            ++i;
        }
        return eg;
    }

    public boolean parseAttributeObjects(AttributeItemContainer attributeContainer, Element attributeContainerElement) {
        NodeList attributeObjectElementList = attributeContainerElement.getElementsByTagNameNS(SCHEMA_NAMESPACE, "*");
        int i = 0;
        while (i < attributeObjectElementList.getLength()) {
            if (attributeObjectElementList.item(i).getNodeType() == 1) {
                Element attributeObjectElement = (Element)attributeObjectElementList.item(i);
                if (attributeObjectElement.getLocalName().equals("attribute")) {
                    AttributeItem attributeItem = this.parseAttributeItem(attributeObjectElement);
                    attributeContainer.addAttribute(attributeItem);
                } else if (attributeObjectElement.getLocalName().equals("attributeGroup")) {
                    String name = attributeObjectElement.getAttribute("ref");
                    AttributeGrouping attributeGrouping = this.resolveAttributeGrouping(attributeObjectElement, name);
                    if (attributeGrouping != null) {
                        for (AttributeItem attributeItem : attributeGrouping.getAttributes()) {
                            attributeContainer.addAttribute(attributeItem);
                        }
                    } else {
                        this.addProblem(this.createProblem("Attribute group could not be resolved.", attributeObjectElement));
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public AttributeItem parseAttributeItem(Element attributeItemElement) {
        Attr formAttributeNode;
        Attr fixedAttributeNode;
        if (!attributeItemElement.getAttribute("ref").equals("")) {
            return this.globalAttributesByName.get(attributeItemElement.getAttribute("ref"));
        }
        AttributeItem attributeItem = new AttributeItem(this, attributeItemElement.getAttribute("name"));
        Attr defaultAttributeNode = attributeItemElement.getAttributeNode("default");
        if (defaultAttributeNode != null) {
            attributeItem.setDefaultValue(defaultAttributeNode.getValue());
        }
        if ((fixedAttributeNode = attributeItemElement.getAttributeNode("fixed")) != null) {
            attributeItem.setFixedValue(fixedAttributeNode.getValue());
        }
        if ((formAttributeNode = attributeItemElement.getAttributeNode("form")) != null) {
            attributeItem.setQualifyOverride(true);
            attributeItem.setQualified(formAttributeNode.getValue().equals("qualified"));
        }
        attributeItem.setRequired(attributeItemElement.getAttribute("use").equals("required"));
        SimpleType type = null;
        String typeString = attributeItemElement.getAttribute("type");
        if (!typeString.equals("")) {
            type = (SimpleType)this.resolveType(attributeItemElement, typeString);
        } else {
            NodeList simpleTypeElementList = attributeItemElement.getElementsByTagNameNS(SCHEMA_NAMESPACE, "simpleType");
            if (simpleTypeElementList.getLength() > 0) {
                type = this.parseSimpleType((Element)simpleTypeElementList.item(0));
            }
        }
        if (type == null) {
            this.addProblem(this.createProblem("Base type '" + typeString + "' not found or invalid.", attributeItemElement));
        }
        attributeItem.setType(type);
        return attributeItem;
    }

    public Type resolveType(Element hostElement, String qName) {
        String[] baseParts = qName.split(":");
        String prefix = null;
        if (baseParts.length > 1) {
            prefix = baseParts[0];
        }
        String nameSpace = hostElement.lookupNamespaceURI(prefix);
        String partialName = baseParts[baseParts.length - 1];
        return this.resolveType(nameSpace, partialName);
    }

    public Type resolveType(String uri, String name) {
        if (uri == null || uri.equals(this.targetNamespace)) {
            return this.localTypesByName.get(name);
        }
        Schema schema = this.schemasByNamespace.get(uri);
        if (schema == null) {
            return null;
        }
        return schema.getType(name);
    }

    public AttributeGrouping resolveAttributeGrouping(Element hostElement, String qName) {
        String[] baseParts = qName.split(":");
        String prefix = null;
        if (baseParts.length > 1) {
            prefix = baseParts[0];
        }
        String nameSpace = hostElement.lookupNamespaceURI(prefix);
        String partialName = baseParts[baseParts.length - 1];
        if (nameSpace == null || nameSpace.equals(this.targetNamespace)) {
            return this.globalAttributeGroupsByName.get(partialName);
        }
        Schema schema = this.schemasByNamespace.get(nameSpace);
        if (schema == null) {
            return null;
        }
        return schema.getAttributeGrouping(partialName);
    }

    public ElementGrouping resolveElementGrouping(Element hostElement, String qName) {
        String[] baseParts = qName.split(":");
        String prefix = null;
        if (baseParts.length > 1) {
            prefix = baseParts[0];
        }
        String nameSpace = hostElement.lookupNamespaceURI(prefix);
        String partialName = baseParts[baseParts.length - 1];
        if (nameSpace == null || nameSpace.equals(this.targetNamespace)) {
            return this.globalElementGroupsByName.get(partialName);
        }
        Schema schema = this.schemasByNamespace.get(nameSpace);
        if (schema == null) {
            return null;
        }
        return schema.getElementGrouping(partialName);
    }

    public ElementItem resolveElementItem(Element hostElement, String qName) {
        String[] baseParts = qName.split(":");
        String prefix = null;
        if (baseParts.length > 1) {
            prefix = baseParts[0];
        }
        String nameSpace = hostElement.lookupNamespaceURI(prefix);
        String partialName = baseParts[baseParts.length - 1];
        return this.resolveElementItem(nameSpace, partialName);
    }

    public ElementItem resolveElementItem(String uri, String name) {
        if (uri == null || uri.equals(this.targetNamespace)) {
            return this.globalElementsByName.get(name);
        }
        Schema schema = this.schemasByNamespace.get(uri);
        if (schema == null) {
            return null;
        }
        return schema.getElementItem(name);
    }

    public Type getType(String localName) {
        return this.localTypesByName.get(localName);
    }

    public AttributeGrouping getAttributeGrouping(String localName) {
        return this.globalAttributeGroupsByName.get(localName);
    }

    public ElementGrouping getElementGrouping(String localName) {
        return this.globalElementGroupsByName.get(localName);
    }

    public ElementItem getElementItem(String localName) {
        return this.globalElementsByName.get(localName);
    }

    public void addSchema(Schema schema) {
        this.schemasByNamespace.put(schema.targetNamespace, schema);
    }

    private SchemaProblem createProblem(String message, Element source) {
        return this.createProblem(message, source, null);
    }

    private SchemaProblem createProblem(String message, Element source, Throwable t) {
        Object userData = source.getUserData("line_Number");
        int lineNumber = -1;
        if (userData != null && userData instanceof String) {
            try {
                lineNumber = Integer.parseInt((String)userData);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new SchemaProblem(message, lineNumber, t);
    }

    public boolean shouldQualifyElements() {
        return this.qualifyElements;
    }

    public boolean shouldQualifyAttributes() {
        return this.qualifyAttributes;
    }

    public static void main(String[] args) {
        File file;
        if (args.length < 1) {
            System.out.println("Usage: java Schema file_path");
            System.exit(1);
        }
        if (!(file = new File(args[0])).exists()) {
            System.out.println("Usage: java Schema file_path");
            System.exit(1);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(file);
            Element rootElement = document.getDocumentElement();
            Schema schema = new Schema(rootElement);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

