/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.configuration;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationException;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.model.elements.core.configuration.ExitBinding;
import org.eclipse.vtp.desktop.model.elements.core.configuration.FragmentConfigurationListener;
import org.eclipse.vtp.desktop.model.elements.core.configuration.InputBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FragmentConfigurationManager
implements ConfigurationManager {
    public static final String TYPE_ID = "org.eclipse.vtp.configuration.include";
    public static final String XML_VERSION = "1.0.0";
    private BrandManager brandManager = null;
    private String entryId = null;
    private Map<String, InputBinding> inputBindings = new TreeMap<String, InputBinding>();
    private Map<String, ExitBinding> exitBindings = new TreeMap<String, ExitBinding>();
    private List<FragmentConfigurationListener> listeners = new LinkedList<FragmentConfigurationListener>();

    public FragmentConfigurationManager(IDesign design) {
        this.brandManager = design.getDocument().getProject().getBrandManager();
    }

    private FragmentConfigurationManager(BrandManager brandManager) {
        this.brandManager = brandManager;
    }

    public String getType() {
        return TYPE_ID;
    }

    public String getXMLVersion() {
        return XML_VERSION;
    }

    public BrandManager getBrandManager() {
        return this.brandManager;
    }

    public String getEntryId() {
        return this.entryId;
    }

    public void setEntryId(String entryId) {
        this.entryId = entryId;
        for (FragmentConfigurationListener listener : this.listeners) {
            listener.entryChanged(this);
        }
    }

    public List<InputBinding> getInputBindings() {
        return new LinkedList<InputBinding>(this.inputBindings.values());
    }

    public InputBinding addInputBinding(String input) {
        InputBinding ret = this.inputBindings.get(input);
        if (ret == null) {
            ret = new InputBinding(this, input);
            this.inputBindings.put(input, ret);
        }
        return ret;
    }

    public void removeInputBinding(String input) {
        this.inputBindings.remove(input);
    }

    public void clearInputBindings() {
        this.inputBindings.clear();
    }

    public ExitBinding getExitBinding(String exit) {
        return this.exitBindings.get(exit);
    }

    public List<ExitBinding> getExitBindings() {
        return new LinkedList<ExitBinding>(this.exitBindings.values());
    }

    public ExitBinding addExitBinding(String exit) {
        ExitBinding ret = this.exitBindings.get(exit);
        if (ret == null) {
            ret = new ExitBinding(this, exit);
            this.exitBindings.put(exit, ret);
        }
        return ret;
    }

    public void removeExitBinding(String exit) {
        this.exitBindings.remove(exit);
    }

    public void clearExitBindings() {
        this.exitBindings.clear();
    }

    public void readConfiguration(Element configuration) throws ConfigurationException {
        this.entryId = configuration.getAttribute("entry-id");
        NodeList inputElementList = configuration.getElementsByTagName("input-binding");
        int i = 0;
        while (i < inputElementList.getLength()) {
            Element inputElement = (Element)inputElementList.item(i);
            String inputName = inputElement.getAttribute("name");
            InputBinding inputBinding = new InputBinding(this, inputName);
            inputBinding.readConfiguration(inputElement);
            this.inputBindings.put(inputName, inputBinding);
            ++i;
        }
        NodeList exitElementList = configuration.getElementsByTagName("exit-binding");
        int i2 = 0;
        while (i2 < exitElementList.getLength()) {
            Element exitElement = (Element)exitElementList.item(i2);
            String exitName = exitElement.getAttribute("name");
            ExitBinding exitBinding = new ExitBinding(this, exitName);
            exitBinding.readConfiguration(exitElement);
            this.exitBindings.put(exitName, exitBinding);
            ++i2;
        }
    }

    public void writeConfiguration(Element configuration) {
        configuration.setAttribute("entry-id", this.entryId);
        for (InputBinding inputBinding : this.inputBindings.values()) {
            Element inputElement = configuration.getOwnerDocument().createElement("input-binding");
            configuration.appendChild(inputElement);
            inputElement.setAttribute("name", inputBinding.getInput());
            inputBinding.writeConfiguration(inputElement);
        }
        for (ExitBinding exitBinding : this.exitBindings.values()) {
            Element exitElement = configuration.getOwnerDocument().createElement("exit-binding");
            configuration.appendChild(exitElement);
            exitElement.setAttribute("name", exitBinding.getName());
            exitBinding.writeConfiguration(exitElement);
        }
    }

    public Object clone() {
        FragmentConfigurationManager copy = new FragmentConfigurationManager(this.brandManager);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.getDOMImplementation().createDocument(null, "temporary-document", null);
            Element rootElement = document.getDocumentElement();
            rootElement.setAttribute("xml-version", XML_VERSION);
            this.writeConfiguration(rootElement);
            copy.readConfiguration(rootElement);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return copy;
    }

    public void addListener(FragmentConfigurationListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(FragmentConfigurationListener listener) {
        this.listeners.remove(listener);
    }
}

