/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.configuration;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.BrandManagerListener;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.elements.core.configuration.FragmentConfigurationManager;
import org.eclipse.vtp.desktop.model.elements.core.configuration.InputBrandBinding;
import org.eclipse.vtp.desktop.model.elements.core.configuration.InputItem;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InputBinding
implements BrandManagerListener {
    private FragmentConfigurationManager manager = null;
    private String name = null;
    private Map<String, InputBrandBinding> brandBindings = new TreeMap<String, InputBrandBinding>();

    public InputBinding(FragmentConfigurationManager manager, String name) {
        this.manager = manager;
        this.name = name;
        BrandManager brandManager = manager.getBrandManager();
        IBrand defaultBrand = brandManager.getDefaultBrand();
        InputBrandBinding brandBinding = this.createBrandBinding(defaultBrand);
        InputItem value = new InputItem();
        value.setType("NONE");
        brandBinding.setValue(value);
        brandManager.addListener((BrandManagerListener)this);
    }

    public String getInput() {
        return this.name;
    }

    public InputBrandBinding getBrandBinding(IBrand brand) {
        return this.brandBindings.get(brand.getId());
    }

    public void readConfiguration(Element inputBindingElement) {
        NodeList brandBindingElementList = inputBindingElement.getElementsByTagName("brand-binding");
        int i = 0;
        while (i < brandBindingElementList.getLength()) {
            Element brandBindingElement = (Element)brandBindingElementList.item(i);
            String brandId = brandBindingElement.getAttribute("id");
            InputBrandBinding brandBinding = this.brandBindings.get(brandId);
            if (brandBinding != null) {
                brandBinding.readConfiguration(brandBindingElement);
            }
            ++i;
        }
    }

    public void writeConfiguration(Element inputBindingElement) {
        for (InputBrandBinding brandBinding : this.brandBindings.values()) {
            if (brandBinding.isInherited()) continue;
            Element brandBindingElement = inputBindingElement.getOwnerDocument().createElement("brand-binding");
            inputBindingElement.appendChild(brandBindingElement);
            brandBindingElement.setAttribute("id", brandBinding.getBrand().getId());
            brandBindingElement.setAttribute("name", brandBinding.getBrand().getName());
            brandBinding.writeConfiguration(brandBindingElement);
        }
    }

    public void dumpContents(PrintStream out) {
        out.println("[Language Binding] " + this.name);
        out.println("IBrand Bindings");
        for (InputBrandBinding brandBinding : this.brandBindings.values()) {
            brandBinding.dumpContents(out);
        }
    }

    private InputBrandBinding createBrandBinding(IBrand brand) {
        InputBrandBinding brandBinding = new InputBrandBinding(this.manager, brand);
        this.brandBindings.put(brand.getId(), brandBinding);
        List children = brand.getChildBrands();
        for (IBrand child : children) {
            InputBrandBinding bindingChild = this.createBrandBinding(child);
            bindingChild.setParent(brandBinding);
        }
        return brandBinding;
    }

    public void brandAdded(IBrand brand) {
        InputBrandBinding parentBinding = this.brandBindings.get(brand.getParent().getId());
        InputBrandBinding brandBinding = this.createBrandBinding(brand);
        brandBinding.setParent(parentBinding);
    }

    public void brandNameChanged(IBrand brand, String oldName) {
    }

    public void brandParentChanged(IBrand brand, IBrand oldParent) {
    }

    public void brandRemoved(IBrand brand) {
        this.brandBindings.remove(brand.getId());
    }
}

