/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.configuration;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.BrandManagerListener;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.elements.core.configuration.FragmentConfigurationManager;
import org.eclipse.vtp.desktop.model.elements.core.configuration.OutputBrandBinding;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OutputBinding
implements BrandManagerListener {
    private FragmentConfigurationManager manager = null;
    private String name = null;
    private Map<String, OutputBrandBinding> brandBindings = new TreeMap<String, OutputBrandBinding>();

    public OutputBinding(FragmentConfigurationManager manager, String name) {
        this.manager = manager;
        this.name = name;
        BrandManager brandManager = manager.getBrandManager();
        IBrand defaultBrand = brandManager.getDefaultBrand();
        this.createBrandBinding(defaultBrand);
        brandManager.addListener((BrandManagerListener)this);
    }

    public String getOutput() {
        return this.name;
    }

    public OutputBrandBinding getBrandBinding(IBrand brand) {
        return this.brandBindings.get(brand.getId());
    }

    public void readConfiguration(Element inputBindingElement) {
        NodeList brandBindingElementList = inputBindingElement.getElementsByTagName("brand-binding");
        int i = 0;
        while (i < brandBindingElementList.getLength()) {
            Element brandBindingElement = (Element)brandBindingElementList.item(i);
            String brandId = brandBindingElement.getAttribute("id");
            OutputBrandBinding brandBinding = this.brandBindings.get(brandId);
            if (brandBinding != null) {
                brandBinding.readConfiguration(brandBindingElement);
            }
            ++i;
        }
    }

    public void writeConfiguration(Element inputBindingElement) {
        for (OutputBrandBinding brandBinding : this.brandBindings.values()) {
            if (brandBinding.isInherited()) continue;
            Element brandBindingElement = inputBindingElement.getOwnerDocument().createElement("brand-binding");
            inputBindingElement.appendChild(brandBindingElement);
            brandBindingElement.setAttribute("id", brandBinding.getBrand().getId());
            brandBindingElement.setAttribute("name", brandBinding.getBrand().getName());
            brandBinding.writeConfiguration(brandBindingElement);
        }
    }

    public void dumpContents(PrintStream out) {
        out.println("[Output Binding] " + this.name);
        out.println("IBrand Bindings");
        for (OutputBrandBinding brandBinding : this.brandBindings.values()) {
            brandBinding.dumpContents(out);
        }
    }

    private OutputBrandBinding createBrandBinding(IBrand brand) {
        OutputBrandBinding brandBinding = new OutputBrandBinding(this.manager, brand);
        this.brandBindings.put(brand.getId(), brandBinding);
        List children = brand.getChildBrands();
        for (IBrand child : children) {
            OutputBrandBinding bindingChild = this.createBrandBinding(child);
            bindingChild.setParent(brandBinding);
        }
        return brandBinding;
    }

    public void brandAdded(IBrand brand) {
        OutputBrandBinding parentBinding = this.brandBindings.get(brand.getParent().getId());
        OutputBrandBinding brandBinding = this.createBrandBinding(brand);
        brandBinding.setParent(parentBinding);
    }

    public void brandNameChanged(IBrand brand, String oldName) {
    }

    public void brandParentChanged(IBrand brand, IBrand oldParent) {
    }

    public void brandRemoved(IBrand brand) {
        this.brandBindings.remove(brand.getId());
    }
}

