/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.export;

import org.eclipse.vtp.framework.common.configurations.AssignmentConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigurationExportHelper {
    public static void configureAssignmentAction(Element configuration, Element actionElement) {
        String uri = "http://www.eclipse.org/vtp/namespaces/config";
        NodeList variableList = ((Element)((Element)configuration.getElementsByTagNameNS(uri, "custom-config").item(0)).getElementsByTagNameNS(uri, "declarations").item(0)).getElementsByTagNameNS(uri, "variable");
        int i = 0;
        while (i < variableList.getLength()) {
            Element variable = (Element)variableList.item(i);
            AssignmentConfiguration config = new AssignmentConfiguration();
            config.setName(variable.getAttribute("name"));
            config.setSecured(Boolean.parseBoolean(variable.getAttribute("secured")));
            if (variable.getAttributeNode("type") != null) {
                if ("1".equals(variable.getAttribute("multiplicity")) || "array".equalsIgnoreCase(variable.getAttribute("multiplicity"))) {
                    config.setType("Array");
                } else if ("DateTime".equals(variable.getAttribute("type"))) {
                    config.setType("Date");
                } else {
                    config.setType(variable.getAttribute("type"));
                }
            } else {
                Element fieldTypeElement = (Element)variable.getElementsByTagName("data-type").item(0);
                String typeStr = fieldTypeElement.getAttribute("type");
                if (typeStr.indexOf(58) != -1) {
                    typeStr = typeStr.substring(typeStr.indexOf(58) + 1);
                }
                if ("DateTime".equals(typeStr)) {
                    typeStr = "Date";
                }
                config.setType(typeStr);
            }
            String value = variable.getAttribute("value");
            if (value != null && value.length() > 0) {
                config.setValue(value);
            }
            Element configElement = actionElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/common/configurations", "common:assignment");
            config.save(configElement);
            actionElement.appendChild(configElement);
            ++i;
        }
    }
}

