/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.internal;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.IExitBroadcastReceiver;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveBroadcastReceiverProvider;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElementManager;
import org.eclipse.vtp.desktop.model.elements.core.internal.views.PalletItemFilter;
import org.w3c.dom.Element;

public class PrimitiveElement
extends DesignElement {
    public static final String ELEMENT_TYPE = "org.eclipse.vtp.desktop.model.elements.core.basic";
    private String subTypeId;
    private String subTypeName;
    private PrimitiveInformationProvider info;
    private PalletItemFilter filter = null;

    public PrimitiveElement(String subTypeId, String name) {
        super(name);
        this.getProperties().setProperty("type", subTypeId);
        this.subTypeId = subTypeId;
        PrimitiveElementManager.PrimitiveElementTemplate template = PrimitiveElementManager.getDefault().getElementTemplate(subTypeId);
        this.subTypeName = template.getName();
        this.info = template.getInformationProviderInstance(this);
        this.filter = template.getFilter();
    }

    public PrimitiveElement(String id, String name, Properties properties) {
        super(id, name, properties);
        this.subTypeId = properties.getProperty("type");
        PrimitiveElementManager.PrimitiveElementTemplate template = PrimitiveElementManager.getDefault().getElementTemplate(this.subTypeId);
        this.subTypeName = template.getName();
        this.info = template.getInformationProviderInstance(this);
        this.filter = template.getFilter();
    }

    public String getTitle() {
        return String.valueOf(super.getTitle()) + " (" + this.getTypeName() + ")";
    }

    public void markDirty() {
        this.fireChange();
    }

    public boolean canDelete() {
        return this.info.canDelete();
    }

    public IDesignElementConnectionPoint getConnectorRecord(String recordName) {
        return this.info.getConnectorRecord(recordName);
    }

    public List<IDesignElementConnectionPoint> getConnectorRecords() {
        return new LinkedList<ConnectorRecord>(this.info.getConnectorRecords());
    }

    public List<IDesignElementConnectionPoint> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        return new LinkedList<ConnectorRecord>(this.info.getConnectorRecords(types));
    }

    public void readCustomConfiguration(Element configuration) {
        this.info.readConfiguration(configuration);
    }

    public void writeCustomConfiguration(Element customElement) {
        this.info.writeConfiguration(customElement);
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return this.info.acceptsConnector(origin);
    }

    public void showProperties() {
    }

    public String getType() {
        return ELEMENT_TYPE;
    }

    public String getTypeName() {
        return this.subTypeName;
    }

    public String getSubTypeId() {
        return this.subTypeId;
    }

    public PrimitiveInformationProvider getInformationProvider() {
        return this.info;
    }

    public Image getIcon() {
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        return imageRegistry.get(this.subTypeId);
    }

    public List<Variable> getOutgoingVariables(String exitPoint, boolean localOnly) {
        return this.info.getOutgoingVariables(exitPoint, localOnly);
    }

    public void resolve() {
        this.info.resolve();
        this.declareBusinessObjects();
    }

    public void declareBusinessObjects() {
        this.info.declareBusinessObjects();
    }

    public boolean hasPathToStart(Map<String, IDesignElement> originPath) {
        if (originPath == null) {
            originPath = new HashMap<String, IDesignElement>();
        }
        return super.hasPathToStart(originPath) || this.info.hasPathToStart(originPath);
    }

    public boolean hasConnectors() {
        return this.info.hasConnectors();
    }

    public List<IExitBroadcastReceiver> getExitBroadcastReceivers() {
        if (this.info instanceof PrimitiveBroadcastReceiverProvider) {
            return ((PrimitiveBroadcastReceiverProvider)((Object)this.info)).getExitBroadcastReceivers();
        }
        return super.getExitBroadcastReceivers();
    }

    public boolean canBeContainedBy(IDesign design) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.canBeContainedBy(design);
    }

    public Object getAdapter(Class adapter) {
        return this.info.getAdapter(adapter);
    }
}

