/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.IBusinessObject;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.BusinessObject;
import org.eclipse.vtp.desktop.model.core.internal.BusinessObjectField;
import org.eclipse.vtp.desktop.model.core.internal.VariableHelper;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ScriptedPrimitiveInformationProvider
extends PrimitiveInformationProvider {
    String typeId;
    String typeName;
    boolean acceptsConnectors = false;
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    List<Variable> variables = new ArrayList<Variable>();
    IConfigurationElement configurationElement = null;
    boolean canDelete = true;
    boolean hasConnectors = false;
    List<VarRecord> varRecords = new ArrayList<VarRecord>();
    List<VarPropertySet> varPropertySets = new ArrayList<VarPropertySet>();

    public ScriptedPrimitiveInformationProvider(PrimitiveElement element) {
        super(element);
    }

    public void init(IConfigurationElement configurationElement) {
        this.acceptsConnectors = Boolean.parseBoolean(configurationElement.getAttribute("acceptsConnectors"));
        if (configurationElement.getAttribute("canDelete") != null) {
            this.canDelete = Boolean.parseBoolean(configurationElement.getAttribute("canDelete"));
        }
        this.typeId = configurationElement.getAttribute("typeid");
        this.typeName = configurationElement.getAttribute("typename");
        IConfigurationElement exitPointsElement = configurationElement.getChildren("exit_points")[0];
        IConfigurationElement[] exitPointElements = exitPointsElement.getChildren("exit_point");
        int i = 0;
        while (i < exitPointElements.length) {
            ConnectorRecord cr = new ConnectorRecord((DesignElement)this.getElement(), exitPointElements[i].getAttribute("name"), IDesignElementConnectionPoint.ConnectionPointType.valueOf((String)exitPointElements[i].getAttribute("type")));
            this.connectorRecords.add(cr);
            this.hasConnectors = true;
            ++i;
        }
        IConfigurationElement actionsElement = configurationElement.getChildren("variables")[0];
        IConfigurationElement[] actionElements = actionsElement.getChildren("variable");
        int i2 = 0;
        while (i2 < actionElements.length) {
            String variableName = actionElements[i2].getAttribute("name");
            String variableType = actionElements[i2].getAttribute("type");
            if (variableType != null) {
                FieldType.Primitive prim;
                boolean array = false;
                if (actionElements[i2].getAttribute("array") != null && "true".equalsIgnoreCase(actionElements[i2].getAttribute("array"))) {
                    array = true;
                }
                if ((prim = FieldType.Primitive.find((String)variableType)) != null) {
                    if (array) {
                        this.varPropertySets.add(new VarPropertySet(variableName, FieldType.Primitive.ARRAY.getName(), variableType));
                    } else {
                        this.varPropertySets.add(new VarPropertySet(variableName, variableType, null));
                    }
                } else if (array) {
                    this.varPropertySets.add(new VarPropertySet(variableName, FieldType.Primitive.ARRAY.getName(), variableType));
                } else {
                    this.varPropertySets.add(new VarPropertySet(variableName, variableType, null));
                }
            } else {
                String ftBaseTypeName = null;
                int precision = 1;
                IConfigurationElement[] typeElements = actionElements[i2].getChildren("data-type");
                if (typeElements.length > 0) {
                    String typeName;
                    IConfigurationElement element = typeElements[0];
                    String ftTypeName = typeName = element.getAttribute("type");
                    if (typeName.startsWith("primitive:")) {
                        ftTypeName = typeName = typeName.substring(10);
                        FieldType.Primitive type = FieldType.Primitive.find((String)typeName);
                        if (type.hasBaseType()) {
                            String baseTypeName = element.getAttribute("base-type");
                            if (baseTypeName.startsWith("primitive:")) {
                                ftBaseTypeName = baseTypeName = baseTypeName.substring(10);
                                FieldType.Primitive baseType = FieldType.Primitive.find((String)baseTypeName);
                                if (baseType.hasPrecision()) {
                                    try {
                                        precision = Integer.parseInt(element.getAttribute("precision"));
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                }
                            } else {
                                ftBaseTypeName = baseTypeName = baseTypeName.substring(7);
                            }
                        }
                        if (type.hasPrecision()) {
                            try {
                                precision = Integer.parseInt(element.getAttribute("precision"));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    this.varPropertySets.add(new VarPropertySet(variableName, ftTypeName, ftBaseTypeName, precision));
                }
            }
            ++i2;
        }
    }

    @Override
    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    @Override
    public List<ConnectorRecord> getConnectorRecords() {
        return this.connectorRecords;
    }

    @Override
    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        int flags = IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types);
        if ((flags & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException("DesignConnector type must be one of those defined in the class ConnectorRecord.");
        }
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getType().isSet(flags)) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    @Override
    public void readConfiguration(Element configuration) {
    }

    @Override
    public void writeConfiguration(Element configuration) {
    }

    @Override
    public boolean acceptsConnector(IDesignElement origin) {
        return this.acceptsConnectors;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public boolean hasConnectors() {
        return this.hasConnectors;
    }

    public void addVariable(String name, FieldType type) {
        Variable v = new Variable(name, type);
        VariableHelper.buildObjectFields((ObjectDefinition)v, (IBusinessObjectSet)this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet());
        this.variables.add(v);
    }

    @Override
    public List<Variable> getOutgoingVariables(String exitPoint, boolean localOnly) {
        this.varRecords.clear();
        for (VarPropertySet vps : this.varPropertySets) {
            this.varRecords.add(this.createVarRecord(vps));
        }
        if (this.variables.size() == 0 && this.varRecords.size() != 0) {
            for (VarRecord vr : this.varRecords) {
                this.addVariable(vr.name, vr.type);
            }
        }
        return this.variables;
    }

    public void declareBusinessObjects(IBusinessObjectSet businessObjectSet) {
        if (this.configurationElement != null) {
            IConfigurationElement[] bosArray = this.configurationElement.getChildren("business-objects");
            if (bosArray != null && bosArray.length > 0 && bosArray[0] != null) {
                IConfigurationElement[] boElements = bosArray[0].getChildren("business-object");
                int i = 0;
                while (i < boElements.length) {
                    boolean safeToCreate = false;
                    String boDefName = boElements[i].getAttribute("name");
                    HashMap<String, BusinessObjectFieldDefinition> fieldDefs = new HashMap<String, BusinessObjectFieldDefinition>();
                    IConfigurationElement[] fieldElements = boElements[i].getChildren("field");
                    int c = 0;
                    while (c < fieldElements.length) {
                        String name = fieldElements[c].getAttribute("name");
                        FieldType ft = null;
                        String type = fieldElements[c].getAttribute("type");
                        if (fieldElements[c].getAttribute("object") != null) {
                            boolean array = Boolean.parseBoolean(fieldElements[c].getAttribute("array"));
                            FieldType.Primitive prim = FieldType.Primitive.find((String)type);
                            if (prim != null) {
                                ft = array ? new FieldType(FieldType.Primitive.ARRAY, prim) : new FieldType(prim);
                            } else {
                                IBusinessObject bo = businessObjectSet.getBusinessObject(type);
                                ft = array ? new FieldType(FieldType.Primitive.ARRAY, bo) : new FieldType(bo);
                            }
                        } else {
                            FieldType.Primitive prim = FieldType.Primitive.find((String)type);
                            if (prim != null) {
                                String baseType;
                                FieldType.Primitive basePrim;
                                ft = prim.hasBaseType() ? ((basePrim = FieldType.Primitive.find((String)(baseType = fieldElements[c].getAttribute("basetype")))) != null ? new FieldType(prim, basePrim) : new FieldType(prim, businessObjectSet.getBusinessObject(baseType))) : new FieldType(prim);
                            } else {
                                IBusinessObject bo = businessObjectSet.getBusinessObject(type);
                                ft = new FieldType(bo);
                            }
                        }
                        String precisionText = fieldElements[c].getAttribute("precision");
                        int precision = "double".equals(precisionText) ? 1 : ("absolute".equals(precisionText) ? 2 : 0);
                        ft.setPrecision(precision);
                        String initialValue = fieldElements[c].getAttribute("initial_value");
                        if (initialValue == null) {
                            initialValue = "";
                        }
                        boolean secured = Boolean.parseBoolean(fieldElements[c].getAttribute("secured"));
                        fieldDefs.put(fieldElements[c].getAttribute("name"), new BusinessObjectFieldDefinition(name, ft, initialValue, secured));
                        ++c;
                    }
                    List existingBOs = businessObjectSet.getBusinessObjects();
                    if (existingBOs != null && existingBOs.size() > 0) {
                        boolean noBoNameMatches = true;
                        for (IBusinessObject existingBo : existingBOs) {
                            if (!existingBo.getName().equalsIgnoreCase(boDefName)) continue;
                            noBoNameMatches = false;
                            List existingBoFields = existingBo.getFields();
                            boolean fieldsMatch = true;
                            if (fieldDefs.size() == existingBoFields.size()) {
                                for (Object existingBof : existingBoFields) {
                                    if (fieldDefs.containsKey(existingBof.getName())) {
                                        BusinessObjectFieldDefinition newBof = (BusinessObjectFieldDefinition)fieldDefs.get(existingBof.getName());
                                        if (existingBof.getDataType().getPrimitiveType() == newBof.getType().getPrimitiveType() && existingBof.getDataType().getPrimitiveBaseType() == newBof.getType().getPrimitiveType() && existingBof.getDataType().getObjectType() == newBof.getType().getObjectType() && existingBof.getDataType().getObjectBaseType() == newBof.getType().getObjectBaseType() && existingBof.getInitialValue().equals(newBof.getInitialValue()) && existingBof.isSecured() == newBof.isSecured()) continue;
                                        fieldsMatch = false;
                                    } else {
                                        fieldsMatch = false;
                                    }
                                    break;
                                }
                            } else {
                                fieldsMatch = false;
                            }
                            if (fieldsMatch) continue;
                            System.out.println("There is already a Business Object by that name. Skipping declaration of the new one.");
                        }
                        if (noBoNameMatches) {
                            safeToCreate = true;
                        }
                    } else {
                        safeToCreate = true;
                    }
                    if (safeToCreate) {
                        try {
                            Object existingBof;
                            BusinessObject bo = (BusinessObject)businessObjectSet.createBusinessObject(boDefName);
                            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                            Element rootElement = doc.createElement("business-object");
                            doc.appendChild(rootElement);
                            rootElement.setAttribute("id", bo.getId());
                            rootElement.setAttribute("name", bo.getName());
                            Element fields = rootElement.getOwnerDocument().createElement("fields");
                            rootElement.appendChild(fields);
                            existingBof = fieldDefs.values().iterator();
                            while (existingBof.hasNext()) {
                                BusinessObjectFieldDefinition bofd = (BusinessObjectFieldDefinition)existingBof.next();
                                BusinessObjectField bof = new BusinessObjectField(bo, bofd.getName(), bofd.getType(), bofd.getInitialValue(), bofd.isSecured());
                                Element fieldElement = fields.getOwnerDocument().createElement("field");
                                fields.appendChild(fieldElement);
                                fieldElement.setAttribute("name", bof.getName());
                                fieldElement.setAttribute("initialValue", bof.getInitialValue());
                                fieldElement.setAttribute("secured", Boolean.toString(bof.isSecured()));
                                bofd.getType().write(fieldElement);
                            }
                            DOMSource source = new DOMSource(doc);
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            Transformer trans = TransformerFactory.newInstance().newTransformer();
                            trans.setOutputProperty("encoding", "UTF-8");
                            trans.transform(source, new XMLWriter((OutputStream)baos).toXMLResult());
                            bo.write((InputStream)new ByteArrayInputStream(baos.toByteArray()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
            for (VarRecord vr : this.varRecords) {
                this.addVariable(vr.name, vr.type);
            }
        }
    }

    private VarRecord createVarRecord(VarPropertySet vps) {
        FieldType ft;
        FieldType.Primitive type = FieldType.Primitive.find((String)vps.typeName);
        if (type.hasBaseType()) {
            String baseTypeName = vps.baseTypeName;
            FieldType.Primitive baseType = FieldType.Primitive.find((String)baseTypeName);
            if (baseType != null) {
                ft = new FieldType(type, baseType);
                if (baseType.hasPrecision()) {
                    ft.setPrecision(vps.precision);
                }
            } else {
                IBusinessObject bo = this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObject(baseTypeName);
                if (bo == null) {
                    throw new RuntimeException("Missing business object definition: " + baseTypeName);
                }
                ft = new FieldType(type, bo);
            }
        } else {
            ft = new FieldType(type);
        }
        if (type.hasPrecision()) {
            ft.setPrecision(vps.precision);
        }
        return new VarRecord(vps.variableName, ft);
    }

    private class BusinessObjectFieldDefinition {
        private String name;
        private FieldType type;
        private String initialValue;
        private boolean secured;

        BusinessObjectFieldDefinition(String name, FieldType type, String initialValue, boolean secured) {
            this.name = name;
            this.type = type;
            this.initialValue = initialValue;
            this.secured = secured;
        }

        String getName() {
            return this.name;
        }

        FieldType getType() {
            return this.type;
        }

        String getInitialValue() {
            return this.initialValue;
        }

        boolean isSecured() {
            return this.secured;
        }
    }

    private class VarPropertySet {
        String variableName;
        String typeName;
        String baseTypeName;
        int precision = 1;

        public VarPropertySet(String variableName, String typeName, String baseTypeName) {
            this.variableName = variableName;
            this.typeName = typeName;
            this.baseTypeName = baseTypeName;
        }

        public VarPropertySet(String variableName, String typeName, String baseTypeName, int precision) {
            this.variableName = variableName;
            this.typeName = typeName;
            this.baseTypeName = baseTypeName;
            this.precision = precision;
        }
    }

    private class VarRecord {
        String name;
        FieldType type;

        public VarRecord(String name, FieldType type) {
            this.name = name;
            this.type = type;
        }
    }
}

