/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.core.internal.design.Design;
import org.eclipse.vtp.desktop.model.elements.core.internal.ApplicationFragmentElementFactory;
import org.eclipse.vtp.desktop.views.pallet.PalletItem;
import org.eclipse.vtp.desktop.views.pallet.PalletItemObserver;
import org.eclipse.vtp.desktop.views.pallet.PalletItemProvider;

public class ApplicationFragmentPalletProvider
implements PalletItemProvider,
IResourceChangeListener {
    List<PalletItem> primitiveItems = new ArrayList<PalletItem>();
    List<PalletItemObserver> observers = new ArrayList<PalletItemObserver>();

    public ApplicationFragmentPalletProvider() {
        this.loadProjects();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void loadProjects() {
        this.primitiveItems.clear();
        List projects = WorkflowCore.getDefault().getWorkflowModel().listWorkflowProjects();
        for (IWorkflowProject project : projects) {
            PalletItem item = new PalletItem(project.getName(), null, new ApplicationFragmentElementFactory(), project.getId()){

                public boolean canBeContainedBy(Design design) {
                    return design.equals(design.getDocument().getMainDesign());
                }
            };
            item.setPopOnDrop(true);
            this.primitiveItems.add(item);
        }
    }

    public String getName() {
        return "Workflows";
    }

    public List<PalletItem> getPalletItems() {
        return this.primitiveItems;
    }

    public int getRanking() {
        return 30;
    }

    public void createMenu(IAdaptable container, IMenuManager manager, PalletItem[] selectedItems) {
    }

    public void fireUpdate() {
        for (PalletItemObserver observer : this.observers) {
            observer.palletItemsChanged();
        }
    }

    public void addPalletItemObserver(PalletItemObserver observer) {
        this.observers.remove(observer);
        this.observers.add(observer);
    }

    public void removePalletItemObserver(PalletItemObserver observer) {
        this.observers.remove(observer);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        final boolean[] bs = new boolean[1];
        try {
            if (event.getDelta() != null) {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta.getKind() == 1 && delta.getResource() instanceof IProject && WorkflowCore.getDefault().getWorkflowModel().isWorkflowProject((IProject)delta.getResource())) {
                            bs[0] = true;
                        } else if (delta.getKind() == 2 && delta.getResource() instanceof IProject && WorkflowCore.getDefault().getWorkflowModel().isWorkflowProject((IProject)delta.getResource())) {
                            bs[0] = true;
                        }
                        return true;
                    }
                });
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (bs[0]) {
            this.loadProjects();
            this.fireUpdate();
        }
    }
}

