/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.configuration.generic;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BindingItem;
import org.osgi.framework.Bundle;

public class BindingRegistry {
    public static final String bindingTypesExtensionId = "org.eclipse.vtp.desktop.model.interactive.core.bindingTypes";
    private static final BindingRegistry instance = new BindingRegistry();
    private Map<String, BindingType> bindingTypes = new HashMap<String, BindingType>();

    public static BindingRegistry getInstance() {
        return instance;
    }

    public BindingRegistry() {
        IConfigurationElement[] bindingTypeExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(bindingTypesExtensionId);
        int i = 0;
        while (i < bindingTypeExtensions.length) {
            String bindingTypeId = bindingTypeExtensions[i].getAttribute("id");
            String className = bindingTypeExtensions[i].getAttribute("class");
            Bundle contributor = Platform.getBundle((String)bindingTypeExtensions[i].getContributor().getName());
            try {
                Class bindingClass = contributor.loadClass(className);
                BindingType bt = new BindingType(bindingTypeId, bindingClass);
                this.bindingTypes.put(bindingTypeId, bt);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public BindingItem getBindingItem(String bindingType) {
        try {
            return this.bindingTypes.get((Object)bindingType).bindingItemClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private class BindingType {
        String id;
        Class<BindingItem> bindingItemClass;

        public BindingType(String id, Class<BindingItem> bindingItemClass) {
            this.id = id;
            this.bindingItemClass = bindingItemClass;
        }
    }
}

