/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.configuration.generic;

import java.io.PrintStream;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BindingItem;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BindingRegistry;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.GenericBindingManager;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BrandBinding {
    private GenericBindingManager manager = null;
    private IBrand brand = null;
    private BindingItem bindingItem = null;
    private BrandBinding parentBinding = null;

    public BrandBinding(GenericBindingManager manager, IBrand brand) {
        this.manager = manager;
        this.brand = brand;
    }

    public Object clone() {
        BrandBinding copy = new BrandBinding(this.manager, this.brand);
        copy.bindingItem = this.bindingItem;
        copy.parentBinding = this.parentBinding;
        return copy;
    }

    public IBrand getBrand() {
        return this.brand;
    }

    public void setParent(BrandBinding parentBinding) {
        this.parentBinding = parentBinding;
    }

    public boolean hasParent() {
        return this.parentBinding != null;
    }

    public boolean isInherited() {
        return this.bindingItem == null;
    }

    public BindingItem getBindingItem() {
        if (this.bindingItem == null && this.parentBinding != null) {
            return this.parentBinding.getBindingItem();
        }
        return this.bindingItem;
    }

    public void setBindingItem(BindingItem bindingItem) {
        this.bindingItem = bindingItem;
    }

    public void readConfiguration(Element brandBindingElement) {
        NodeList bindingItemElementList = brandBindingElement.getElementsByTagName("binding-item");
        if (bindingItemElementList.getLength() > 0) {
            Element bindingItemElement = (Element)bindingItemElementList.item(0);
            String bindingItemType = bindingItemElement.getAttribute("type");
            BindingItem bindingItem = BindingRegistry.getInstance().getBindingItem(bindingItemType);
            if (bindingItem != null) {
                bindingItem.readConfiguration(bindingItemElement);
                this.bindingItem = bindingItem;
            }
        }
    }

    public void writeConfiguration(Element brandBindingElement) {
        if (this.bindingItem != null) {
            Element bindingItemElement = brandBindingElement.getOwnerDocument().createElement("binding-item");
            brandBindingElement.appendChild(bindingItemElement);
            bindingItemElement.setAttribute("type", this.bindingItem.getType());
            this.bindingItem.writeConfiguration(bindingItemElement);
        }
    }

    public void dumpContents(PrintStream out) {
        out.println("[IBrand Binding] " + this.brand.getName() + "(" + this.brand.getId() + ")");
        out.println("Binding Item " + this.bindingItem);
    }
}

