/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.configuration.generic;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.GenericBindingManager;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.NamedBinding;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InteractionBinding {
    private String interactionType = null;
    private GenericBindingManager manager = null;
    private Map<String, NamedBinding> namedBindings = new TreeMap<String, NamedBinding>();

    public InteractionBinding(GenericBindingManager manager, String interactionType) {
        this.manager = manager;
        this.interactionType = interactionType;
    }

    public String getInteractionType() {
        return this.interactionType;
    }

    public List<NamedBinding> getNamedBindings() {
        ArrayList<NamedBinding> ret = new ArrayList<NamedBinding>();
        ret.addAll(this.namedBindings.values());
        return ret;
    }

    public NamedBinding getNamedBinding(String bindingName) {
        NamedBinding namedBinding = this.namedBindings.get(bindingName);
        if (namedBinding == null) {
            namedBinding = new NamedBinding(this.manager, bindingName);
            this.namedBindings.put(bindingName, namedBinding);
        }
        return namedBinding;
    }

    public void readConfiguration(Element interactionElement) {
        NodeList namedBindingElementList = interactionElement.getElementsByTagName("named-binding");
        int i = 0;
        while (i < namedBindingElementList.getLength()) {
            Element namedBindingElement = (Element)namedBindingElementList.item(i);
            String bindingName = namedBindingElement.getAttribute("name");
            NamedBinding namedBinding = new NamedBinding(this.manager, bindingName);
            namedBinding.readConfiguration(namedBindingElement);
            this.namedBindings.put(bindingName, namedBinding);
            ++i;
        }
    }

    public void writeConfiguration(Element interactionElement) {
        for (NamedBinding namedBinding : this.namedBindings.values()) {
            Element namedBindingElement = interactionElement.getOwnerDocument().createElement("named-binding");
            interactionElement.appendChild(namedBindingElement);
            namedBindingElement.setAttribute("name", namedBinding.getName());
            namedBinding.writeConfiguration(namedBindingElement);
        }
    }

    public void dumpContents(PrintStream out) {
        out.println("[Interaction Binding] " + this.interactionType);
        out.println("Named Bindings");
        for (NamedBinding namedBinding : this.namedBindings.values()) {
            namedBinding.dumpContents(out);
        }
    }

    public void renameNamedBinding(String oldName, String newName) {
        NamedBinding nb = this.namedBindings.get(oldName);
        nb.setName(newName);
        this.namedBindings.put(newName, nb);
        this.namedBindings.remove(oldName);
    }
}

