/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.configuration.generic;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.BrandManagerListener;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BrandBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.GenericBindingManager;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LanguageBinding
implements BrandManagerListener {
    private GenericBindingManager manager = null;
    private String name = null;
    private Map<String, BrandBinding> brandBindings = new TreeMap<String, BrandBinding>();

    public LanguageBinding(GenericBindingManager manager, String name) {
        this.manager = manager;
        this.name = name;
        BrandManager brandManager = manager.getBrandManager();
        IBrand defaultBrand = brandManager.getDefaultBrand();
        this.createBrandBinding(defaultBrand);
        brandManager.addListener((BrandManagerListener)this);
    }

    public LanguageBinding replicate(String replicationName) {
        LanguageBinding copy = new LanguageBinding(this.manager, replicationName);
        for (Map.Entry<String, BrandBinding> entry : this.brandBindings.entrySet()) {
            BrandBinding brandCopy = (BrandBinding)entry.getValue().clone();
            copy.brandBindings.put(brandCopy.getBrand().getId(), brandCopy);
        }
        return copy;
    }

    public void finalize() {
        this.manager.getBrandManager().removeListener((BrandManagerListener)this);
    }

    public String getLanguage() {
        return this.name;
    }

    public BrandBinding getBrandBinding(IBrand brand) {
        return this.brandBindings.get(brand.getId());
    }

    public void readConfiguration(Element languageBindingElement) {
        NodeList brandBindingElementList = languageBindingElement.getElementsByTagName("brand-binding");
        int i = 0;
        while (i < brandBindingElementList.getLength()) {
            Element brandBindingElement = (Element)brandBindingElementList.item(i);
            String brandId = brandBindingElement.getAttribute("id");
            BrandBinding brandBinding = this.brandBindings.get(brandId);
            if (brandBinding != null) {
                brandBinding.readConfiguration(brandBindingElement);
            }
            ++i;
        }
    }

    public void writeConfiguration(Element languageBindingElement) {
        for (BrandBinding brandBinding : this.brandBindings.values()) {
            if (brandBinding.isInherited()) continue;
            Element brandBindingElement = languageBindingElement.getOwnerDocument().createElement("brand-binding");
            languageBindingElement.appendChild(brandBindingElement);
            brandBindingElement.setAttribute("id", brandBinding.getBrand().getId());
            brandBindingElement.setAttribute("name", brandBinding.getBrand().getName());
            brandBinding.writeConfiguration(brandBindingElement);
        }
    }

    public void dumpContents(PrintStream out) {
        out.println("[Language Binding] " + this.name);
        out.println("IBrand Bindings");
        for (BrandBinding brandBinding : this.brandBindings.values()) {
            brandBinding.dumpContents(out);
        }
    }

    private BrandBinding createBrandBinding(IBrand brand) {
        BrandBinding brandBinding = new BrandBinding(this.manager, brand);
        this.brandBindings.put(brand.getId(), brandBinding);
        List children = brand.getChildBrands();
        for (IBrand child : children) {
            BrandBinding bindingChild = this.createBrandBinding(child);
            bindingChild.setParent(brandBinding);
        }
        return brandBinding;
    }

    public void brandAdded(IBrand brand) {
        BrandBinding parentBinding = this.brandBindings.get(brand.getParent().getId());
        BrandBinding brandBinding = this.createBrandBinding(brand);
        brandBinding.setParent(parentBinding);
    }

    public void brandNameChanged(IBrand brand, String oldName) {
    }

    public void brandParentChanged(IBrand brand, IBrand oldParent) {
    }

    public void brandRemoved(IBrand brand) {
        this.brandBindings.remove(brand.getId());
    }
}

