/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.configuration.generic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class PromptBindingCase
extends PromptBindingNode {
    private String condition = null;
    private List<PromptBindingNode> children = new ArrayList<PromptBindingNode>();

    public PromptBindingCase() {
    }

    public PromptBindingCase(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public List<PromptBindingNode> getChildren() {
        return new ArrayList<PromptBindingNode>(this.children);
    }

    public PromptBindingNode getChild(int index) {
        return this.children.get(index);
    }

    public void addChild(PromptBindingNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void addChild(int index, PromptBindingNode child) {
        this.children.add(index, child);
        child.setParent(this);
    }

    public void removeChild(int index) {
        this.children.remove(index).setParent(null);
    }

    public void removeChild(PromptBindingNode child) {
        if (this.children.remove(child)) {
            child.setParent(null);
        }
    }

    public void clearChildren() {
        for (PromptBindingNode child : this.children) {
            child.setParent(null);
        }
        this.children.clear();
    }

    @Override
    void readConfiguration(Element configuration) {
        this.condition = configuration.getAttribute("condition");
        if (this.condition.length() == 0) {
            this.condition = null;
        }
        NodeList contentList = configuration.getChildNodes();
        int i = 0;
        while (i < contentList.getLength()) {
            if (contentList.item(i) instanceof Element) {
                this.addChild(PromptBindingNode.load((Element)contentList.item(i)));
            }
            ++i;
        }
    }

    @Override
    void writeConfiguration(Element configuration) {
        Element thisElement = configuration.getOwnerDocument().createElement("binding-case");
        configuration.appendChild(thisElement);
        if (this.condition != null) {
            thisElement.setAttribute("condition", this.condition);
        }
        for (PromptBindingNode child : this.children) {
            child.writeConfiguration(thisElement);
        }
    }

    @Override
    public Object clone() {
        PromptBindingCase copy = new PromptBindingCase();
        copy.condition = this.condition;
        for (PromptBindingNode child : this.children) {
            copy.addChild((PromptBindingNode)child.clone());
        }
        return copy;
    }
}

