/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.configuration.generic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingCase;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class PromptBindingSwitch
extends PromptBindingNode {
    private List<PromptBindingCase> children = new ArrayList<PromptBindingCase>();

    public List<PromptBindingCase> getChildren() {
        return new ArrayList<PromptBindingCase>(this.children);
    }

    public PromptBindingCase getChild(int index) {
        return this.children.get(index);
    }

    public void addChild(PromptBindingCase child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void addChild(int index, PromptBindingCase child) {
        this.children.add(index, child);
        child.setParent(this);
    }

    public void removeChild(Object child) {
        if (this.children.remove(child)) {
            ((PromptBindingCase)child).setParent(null);
        }
    }

    public void removeChild(int index) {
        this.children.remove(index).setParent(null);
    }

    public void clearChildren() {
        for (PromptBindingCase child : this.children) {
            child.setParent(null);
        }
        this.children.clear();
    }

    @Override
    void readConfiguration(Element configuration) {
        NodeList contentList = configuration.getChildNodes();
        int i = 0;
        while (i < contentList.getLength()) {
            if (contentList.item(i) instanceof Element) {
                Element element = (Element)contentList.item(i);
                PromptBindingCase child = new PromptBindingCase();
                child.readConfiguration(element);
                this.addChild(child);
            }
            ++i;
        }
    }

    @Override
    void writeConfiguration(Element configuration) {
        Element thisElement = configuration.getOwnerDocument().createElement("binding-branch");
        configuration.appendChild(thisElement);
        for (PromptBindingCase child : this.children) {
            child.writeConfiguration(thisElement);
        }
    }

    @Override
    public Object clone() {
        PromptBindingSwitch copy = new PromptBindingSwitch();
        for (PromptBindingCase child : this.children) {
            copy.addChild((PromptBindingCase)child.clone());
        }
        return copy;
    }
}

