/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.configuration.generic;

import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BindingItem;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PropertyBindingItem
implements BindingItem {
    public static final String TYPE_ID = "org.eclipse.vtp.configuration.generic.items.property";
    public static final String STATIC = "static";
    public static final String EXPRESSION = "expression";
    public static final String VARIABLE = "variable";
    private String valueType = "static";
    private String value = null;

    @Override
    public String getType() {
        return TYPE_ID;
    }

    public String getValueType() {
        return this.valueType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setStaticValue(String value) {
        this.valueType = STATIC;
        this.value = value;
    }

    public void setExpression(String expression) {
        this.valueType = EXPRESSION;
        this.value = expression;
    }

    public void setVariable(String variable) {
        this.valueType = VARIABLE;
        this.value = variable;
    }

    @Override
    public void readConfiguration(Element configuration) {
        NodeList propertyValueElementList = configuration.getElementsByTagName("property-value");
        if (propertyValueElementList.getLength() > 0) {
            Element propertyValueElement = (Element)propertyValueElementList.item(0);
            String valueTypeAtt = propertyValueElement.getAttribute("value-type");
            if (VARIABLE.equalsIgnoreCase(valueTypeAtt)) {
                this.valueType = VARIABLE;
            } else if (EXPRESSION.equalsIgnoreCase(valueTypeAtt)) {
                this.valueType = EXPRESSION;
            }
            this.value = XMLUtilities.getElementTextDataNoEx((Element)propertyValueElement, (boolean)true);
        }
    }

    @Override
    public void writeConfiguration(Element configuration) {
        Element propertyValueElement = configuration.getOwnerDocument().createElement("property-value");
        configuration.appendChild(propertyValueElement);
        propertyValueElement.setAttribute("value-type", this.valueType);
        propertyValueElement.setTextContent(this.value);
    }

    @Override
    public Object clone() {
        PropertyBindingItem copy = new PropertyBindingItem();
        copy.valueType = this.valueType;
        copy.value = this.value;
        return copy;
    }
}

