/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.content;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class ContentLoadingManager
implements IContentFactory {
    public static final String contentTypeExtensionId = "org.eclipse.vtp.framework.interactions.core.contenttypes";
    private static final ContentLoadingManager instance = new ContentLoadingManager();
    private Map<String, ContentRegistration> contentTypes = new HashMap<String, ContentRegistration>();
    private Map<String, ContentRegistration> contentTypesById = new HashMap<String, ContentRegistration>();

    public static ContentLoadingManager getInstance() {
        return instance;
    }

    public ContentLoadingManager() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(contentTypeExtensionId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            String contentElementURI = primitiveExtensions[i].getAttribute("element-uri");
            String contentElementName = primitiveExtensions[i].getAttribute("element-name");
            String contentClassName = primitiveExtensions[i].getAttribute("class");
            if (contentElementURI != null && contentElementName != null && contentClassName != null) {
                Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
                try {
                    Class providerClass = contributor.loadClass(contentClassName);
                    ContentRegistration reg = new ContentRegistration();
                    reg.id = primitiveExtensions[i].getAttribute("id");
                    reg.contentElementURI = contentElementURI;
                    reg.contentElementName = contentElementName;
                    reg.contentClass = providerClass;
                    this.contentTypes.put(String.valueOf(contentElementURI) + contentElementName, reg);
                    this.contentTypesById.put(reg.id, reg);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public Content loadContent(Element contentElement) {
        ContentRegistration reg;
        block5: {
            try {
                String uri = contentElement.getNamespaceURI();
                String name = contentElement.getTagName();
                reg = this.contentTypes.get(String.valueOf(uri) + name);
                if (reg != null) break block5;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            return reg.contentClass.getConstructor(IContentFactory.class, Element.class).newInstance(this, contentElement);
        }
        catch (NoSuchMethodException e) {
            return reg.contentClass.getConstructor(Element.class).newInstance(contentElement);
        }
    }

    private class ContentRegistration {
        String id;
        String contentElementURI;
        String contentElementName;
        Class<Content> contentClass;

        private ContentRegistration() {
        }
    }
}

