/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.internal;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.model.interactive.core.internal.LanguageSupport;

public class InteractionTypeSupport
implements Cloneable {
    private String interactionType = null;
    private String interactionTypeName = null;
    private Map<String, LanguageSupport> languageMappings = new HashMap<String, LanguageSupport>();

    public InteractionTypeSupport(String interactionType, String interactionTypeName) {
        this.interactionType = interactionType;
        this.interactionTypeName = interactionTypeName;
    }

    public String getInteractionType() {
        return this.interactionType;
    }

    public String getInteractionTypeName() {
        return this.interactionTypeName;
    }

    public LanguageSupport addLanguageSupport(String language) {
        LanguageSupport ls = this.languageMappings.get(language);
        if (ls == null) {
            ls = new LanguageSupport(language);
            this.languageMappings.put(language, ls);
        }
        return ls;
    }

    private void addLanguageSupport0(String language, LanguageSupport languageMapping) {
        this.languageMappings.put(language, languageMapping);
    }

    public void removeLanguageSupport(String language) {
        this.languageMappings.remove(language);
    }

    public LanguageSupport getLanguageSupport(String language) {
        return this.languageMappings.get(language);
    }

    public List<LanguageSupport> getSupportedLanguages() {
        return new LinkedList<LanguageSupport>(this.languageMappings.values());
    }

    public Object clone() {
        InteractionTypeSupport copy = new InteractionTypeSupport(this.interactionType, this.interactionTypeName);
        for (Map.Entry<String, LanguageSupport> entry : this.languageMappings.entrySet()) {
            copy.addLanguageSupport0(entry.getKey(), (LanguageSupport)entry.getValue().clone());
        }
        return copy;
    }
}

