/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.model.interactive.core.IInteractiveWorkflowModel;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaObject;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaObjectContainer;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaProject;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaProjectFactory;
import org.osgi.framework.Bundle;

public class InteractiveWorkflowModel
implements IInteractiveWorkflowModel {
    public static final String mediaProjectExtensionId = "org.eclipse.vtp.desktop.model.interactive.core.mediaProjects";
    private Map<String, IMediaProjectFactory> projectFactories = new HashMap<String, IMediaProjectFactory>();

    public InteractiveWorkflowModel() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(mediaProjectExtensionId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            String id = primitiveExtensions[i].getAttribute("id");
            String name = primitiveExtensions[i].getAttribute("name");
            String nature = primitiveExtensions[i].getAttribute("nature-id");
            String interactionType = primitiveExtensions[i].getAttribute("interaction-type");
            String className = primitiveExtensions[i].getAttribute("class");
            Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
            try {
                Class factoryClass = contributor.loadClass(className);
                if (IMediaProjectFactory.class.isAssignableFrom(factoryClass)) {
                    this.projectFactories.put(nature, (IMediaProjectFactory)factoryClass.newInstance());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    @Override
    public IMediaProject convertToMediaProject(IProject project) {
        if (!project.isOpen()) {
            return null;
        }
        try {
            String[] natureIds;
            String[] stringArray = natureIds = project.getDescription().getNatureIds();
            int n = natureIds.length;
            int n2 = 0;
            while (n2 < n) {
                String natureId = stringArray[n2];
                IMediaProjectFactory factory = this.projectFactories.get(natureId);
                if (factory != null) {
                    return factory.convertToMediaProject(project);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public IMediaProject createMediaProject(String natureId, String languagePackId, String name) {
        IMediaProjectFactory factory = this.projectFactories.get(natureId);
        if (factory != null) {
            return factory.createMediaProject(name, languagePackId);
        }
        return null;
    }

    @Override
    public IMediaProject getMediaProject(String id) {
        List<IMediaProject> projects = this.listMediaProjects();
        for (IMediaProject mediaProject : projects) {
            if (!mediaProject.getId().equals(id)) continue;
            return mediaProject;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isMediaProject(IProject project) {
        if (!project.isOpen()) {
            return false;
        }
        try {
            String[] natureIds;
            String[] stringArray = natureIds = project.getDescription().getNatureIds();
            int n = natureIds.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String natureId = stringArray[n2];
                IMediaProjectFactory factory = this.projectFactories.get(natureId);
                if (factory != null) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public List<IMediaProject> listMediaProjects() {
        IProject[] rawProjects;
        ArrayList<IMediaProject> projects = new ArrayList<IMediaProject>();
        IProject[] iProjectArray = rawProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = rawProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                String[] natureIds;
                String[] stringArray = natureIds = project.getDescription().getNatureIds();
                int n3 = natureIds.length;
                int n4 = 0;
                while (n4 < n3) {
                    String natureId = stringArray[n4];
                    IMediaProjectFactory factory = this.projectFactories.get(natureId);
                    if (factory != null) {
                        projects.add(factory.convertToMediaProject(project));
                        break;
                    }
                    ++n4;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return projects;
    }

    @Override
    public IMediaObject convertToMediaObject(IResource resource) {
        if (resource instanceof IProject) {
            return this.convertToMediaProject((IProject)resource);
        }
        IProject project = resource.getProject();
        if (project != null && this.isMediaProject(project)) {
            IMediaProject mediaProject = this.convertToMediaProject(project);
            LinkedList<IResource> containers = new LinkedList<IResource>();
            containers.add(resource);
            IContainer container = resource.getParent();
            while (container != null && !container.equals((Object)project)) {
                containers.add(0, (IResource)container);
                container = container.getParent();
            }
            return this.locateMediaObject(mediaProject, containers);
        }
        return null;
    }

    private IMediaObject locateMediaObject(IMediaObjectContainer parentResource, List<IResource> path) {
        IResource resource = path.remove(0);
        for (IMediaObject child : parentResource.getChildren()) {
            IResource adaptedResource = (IResource)child.getAdapter(IResource.class);
            if (adaptedResource == null || !adaptedResource.equals((Object)resource)) continue;
            if (path.isEmpty()) {
                return child;
            }
            if (child instanceof IMediaObjectContainer) {
                return this.locateMediaObject((IMediaObjectContainer)child, path);
            }
            return null;
        }
        return null;
    }
}

