/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;

public class LanguageSupport
implements Cloneable {
    private String language = null;
    private Map<String, String> projectMappings = new HashMap<String, String>();

    public LanguageSupport(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getMediaProjectId(IBrand brand) {
        return this.getMediaProjectId(brand, true);
    }

    public String getMediaProjectId(IBrand brand, boolean inherit) {
        String key = brand.getId();
        String projectId = this.projectMappings.get(key);
        if (inherit && projectId == null && brand.getParent() != null) {
            return this.getMediaProjectId(brand.getParent());
        }
        return projectId;
    }

    public void assignMediaProject(String brandId, String mediaProjectId) {
        String key = brandId;
        this.projectMappings.put(key, mediaProjectId);
    }

    public Object clone() {
        LanguageSupport copy = new LanguageSupport(this.language);
        for (Map.Entry<String, String> entry : this.projectMappings.entrySet()) {
            copy.assignMediaProject(entry.getKey(), entry.getValue());
        }
        return copy;
    }
}

