/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.internal;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaContainer;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaFile;
import org.eclipse.vtp.desktop.model.interactive.core.internal.MediaResource;

public class MediaFile
extends MediaResource
implements IMediaFile {
    private static final String HASHPREFIX = "MEDIAFILE";
    IFile file;

    public MediaFile(IMediaContainer container, IFile file) {
        super(container, (IResource)file);
        this.file = file;
    }

    @Override
    public InputStream open() throws CoreException {
        return this.file.getContents();
    }

    @Override
    public long length() throws CoreException {
        return this.file.getLocation().toFile().length();
    }

    @Override
    public IFile getUnderlyingFile() {
        return this.file;
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (adapterClass.isAssignableFrom(IFile.class)) {
            return this.file;
        }
        return super.getAdapter(adapterClass);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MediaFile) {
            return this.file.equals((Object)((MediaFile)obj).getUnderlyingFile());
        }
        return false;
    }

    public int hashCode() {
        return (HASHPREFIX + this.file.toString()).hashCode();
    }
}

