/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaContainer;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaFile;
import org.eclipse.vtp.desktop.model.interactive.core.internal.IMediaFileFactory;
import org.osgi.framework.Bundle;

public class MediaTypeManager {
    public static final String mediaTypeExtensionId = "org.eclipse.vtp.desktop.model.interactive.core.mediaFileTypes";
    private static final MediaTypeManager INSTANCE = new MediaTypeManager();
    private Map<String, MediaTypeRecord> mediaTypesByExtension = new HashMap<String, MediaTypeRecord>();
    private Map<String, String> mimeTypesByExtension = new HashMap<String, String>();

    public static MediaTypeManager getInstance() {
        return INSTANCE;
    }

    public MediaTypeManager() {
        IConfigurationElement[] mediaTypeExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(mediaTypeExtensionId);
        int i = 0;
        while (i < mediaTypeExtensions.length) {
            block4: {
                MediaTypeRecord mtr = new MediaTypeRecord();
                mtr.id = mediaTypeExtensions[i].getAttribute("id");
                mtr.name = mediaTypeExtensions[i].getAttribute("type-name");
                String className = mediaTypeExtensions[i].getAttribute("class");
                Bundle contributor = Platform.getBundle((String)mediaTypeExtensions[i].getContributor().getName());
                try {
                    mtr.mediaClass = contributor.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    break block4;
                }
                IConfigurationElement[] mappings = mediaTypeExtensions[i].getChildren("mapping");
                int m = 0;
                while (m < mappings.length) {
                    String extension = mappings[m].getAttribute("extension").toLowerCase();
                    String mimeType = mappings[m].getAttribute("mime-type");
                    this.mimeTypesByExtension.put(extension, mimeType);
                    this.mediaTypesByExtension.put(extension, mtr);
                    ++m;
                }
            }
            ++i;
        }
    }

    public String getMimeType(IFile file) {
        String extension = file.getFileExtension().toLowerCase();
        return this.mimeTypesByExtension.get(extension);
    }

    public IMediaFile createMediaFile(IMediaContainer container, IFile file) {
        String extension = file.getFileExtension().toLowerCase();
        MediaTypeRecord mtr = this.mediaTypesByExtension.get(extension);
        if (mtr == null) {
            return null;
        }
        try {
            IMediaFileFactory factory = mtr.mediaClass.newInstance();
            return factory.createMediaFile(container, file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private class MediaTypeRecord {
        String id;
        String name;
        Class<IMediaFileFactory> mediaClass;

        private MediaTypeRecord() {
        }
    }
}

