/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.internal;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaObjectContainer;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaProject;
import org.eclipse.vtp.desktop.model.interactive.core.IPromptSet;
import org.eclipse.vtp.desktop.model.interactive.core.internal.MediaObject;

public class PromptSet
extends MediaObject
implements IPromptSet {
    private static final String HASHPREFIX = "PROMPTSET";
    IFile file;
    IMediaProject parent;

    public PromptSet(IFile file, IMediaProject parent) {
        this.file = file;
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public InputStream read() throws CoreException {
        return this.file.getContents();
    }

    @Override
    public IMediaObjectContainer getParent() {
        return this.parent;
    }

    @Override
    public void write(InputStream source, IProgressMonitor monitor) throws CoreException {
        this.file.setContents(source, true, true, monitor);
    }

    @Override
    protected String getObjectId() {
        return this.file.getFullPath().toPortableString();
    }

    @Override
    public IFile getUnderlyingFile() {
        return this.file;
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (adapterClass.isAssignableFrom(IFile.class)) {
            return this.file;
        }
        return super.getAdapter(adapterClass);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PromptSet) {
            return this.file.equals((Object)((PromptSet)obj).getUnderlyingFile());
        }
        return false;
    }

    public int hashCode() {
        return (HASHPREFIX + this.file.toString()).hashCode();
    }
}

