/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.voice.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.vtp.desktop.model.interactive.core.content.ContentLoadingManager;
import org.eclipse.vtp.desktop.model.interactive.voice.internal.VoiceProject;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class VoiceModel {
    public static final String NS_URI_VOICE = "http://eclipse.org/vtp/xml/media/voice#1.0";
    public static final String PREFIX_VOICE = "voice";
    private static final String ELEMENT_DESCRIPTOR = "descriptor";
    private static final String ELEMENT_SHARED_CONTENT = "shared-content";
    private static final String ATTRIBUTE_ITEM_NAME = "item-name";
    private static final String QUALIFIED_ELEMENT_DESCRIPTOR = "voice:descriptor";
    private static final String QUALIFIED_ELEMENT_SHARED_CONTENT = "voice:shared-content";
    private static final String QUALIFIED_ATTRIBUTE_ITEM_NAME = "voice:item-name";
    private final IFile descriptor;
    private final Map<String, Content> sharedContent = new TreeMap<String, Content>();
    private final List<Runnable> changeObservers = new LinkedList<Runnable>();

    public VoiceModel(IFile descriptor) {
        this.descriptor = descriptor;
    }

    public VoiceModel(VoiceProject project) {
        this.descriptor = project.getPromptSet().getUnderlyingFile();
    }

    public IProject getProject() {
        return this.descriptor.getProject();
    }

    public String[] getSharedContentNames() {
        return this.sharedContent.keySet().toArray(new String[this.sharedContent.size()]);
    }

    public Content getSharedContent(String name) {
        return this.sharedContent.get(name);
    }

    public void putSharedContent(String name, Content content) {
        if (content == null) {
            this.removeSharedContent(name);
        } else {
            this.sharedContent.put(name, content);
            this.fireChangeEvent();
        }
    }

    public void removeSharedContent(String name) {
        if (this.sharedContent.remove(name) != null) {
            this.fireChangeEvent();
        }
    }

    public void load() throws IOException {
        this.sharedContent.clear();
        Document doc = null;
        InputStream input = null;
        try {
            try {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                docBuilderFactory.setNamespaceAware(true);
                docBuilderFactory.setValidating(false);
                input = this.descriptor.getContents();
                doc = docBuilderFactory.newDocumentBuilder().parse(input);
            }
            catch (CoreException e) {
                IOException ex = new IOException("Could not load XML document: " + e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            catch (ParserConfigurationException e) {
                IOException ex = new IOException("Could not initialize XML parser: " + e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            catch (SAXException e) {
                IOException ex = new IOException("Could not parse XML document: " + e.getMessage());
                ex.initCause(e);
                throw ex;
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        NodeList sharedContentList = doc.getDocumentElement().getElementsByTagNameNS(NS_URI_VOICE, ELEMENT_SHARED_CONTENT);
        if (sharedContentList.getLength() > 0) {
            Element sharedContentElement = (Element)sharedContentList.item(0);
            NodeList contentList = sharedContentElement.getChildNodes();
            int i = 0;
            while (i < contentList.getLength()) {
                Content content;
                Element contentElement;
                String name;
                if (contentList.item(i) instanceof Element && (name = (contentElement = (Element)contentList.item(i)).getAttributeNS(NS_URI_VOICE, ATTRIBUTE_ITEM_NAME)) != null && (content = ContentLoadingManager.getInstance().loadContent(contentElement)) != null) {
                    this.sharedContent.put(name, content);
                }
                ++i;
            }
        }
    }

    public void save(IProgressMonitor monitor) throws IOException {
        IOException ex;
        Document doc = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setValidating(false);
            doc = docBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            IOException ex2 = new IOException("Could not initialize XML encoder: " + e.getMessage());
            ex2.initCause(e);
            throw ex2;
        }
        Element desriptorElement = doc.createElementNS(NS_URI_VOICE, QUALIFIED_ELEMENT_DESCRIPTOR);
        doc.appendChild(desriptorElement);
        Element sharedContentElement = doc.createElementNS(NS_URI_VOICE, QUALIFIED_ELEMENT_SHARED_CONTENT);
        desriptorElement.appendChild(sharedContentElement);
        for (Map.Entry<String, Content> entry : this.sharedContent.entrySet()) {
            Element contentElement = entry.getValue().store(sharedContentElement);
            if (contentElement == null) continue;
            contentElement.setAttributeNS(NS_URI_VOICE, QUALIFIED_ATTRIBUTE_ITEM_NAME, String.valueOf(entry.getKey()));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new XMLWriter((OutputStream)baos).toXMLResult());
        }
        catch (TransformerConfigurationException e) {
            ex = new IOException("Could not initialize XML transformer: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (TransformerException e) {
            ex = new IOException("Could not transform XML document: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        try {
            this.descriptor.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, true, monitor);
        }
        catch (CoreException e) {
            ex = new IOException("Could not save XML document: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public void addChangeObserver(Runnable observer) {
        this.changeObservers.add(observer);
    }

    public void removeChangeObserver(Runnable observer) {
        this.changeObservers.remove(observer);
    }

    private void fireChangeEvent() {
        for (Runnable r : this.changeObservers) {
            r.run();
        }
    }
}

