/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.XMLConverter;
import org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.legacysupport.ConversionException;
import org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.legacysupport.LegacySupportManager;
import org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.update.UpgradeSupportManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DocumentConverter {
    public static final String XML_VERSION = "1.0.1";
    private Map<String, Object> dataServices = new HashMap<String, Object>();

    public void convertDocument(Document document) throws Exception {
        Element rootElement = document.getDocumentElement();
        NodeList nl = rootElement.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeType() == 1) {
                Element element = (Element)nl.item(i);
                if (element.getTagName().equals("dialogs")) {
                    NodeList dialogList = element.getElementsByTagName("dialogs");
                    int d = 0;
                    while (d < dialogList.getLength()) {
                        Element dialogElement = (Element)dialogList.item(d);
                        NodeList modelList = dialogElement.getElementsByTagName("model");
                        if (modelList.getLength() > 0) {
                            Element modelElement = (Element)modelList.item(0);
                            this.convertModel(modelElement);
                        }
                        ++d;
                    }
                } else {
                    NodeList modelList = element.getElementsByTagName("model");
                    if (modelList.getLength() > 0) {
                        Element modelElement = (Element)modelList.item(0);
                        this.convertModel(modelElement);
                    }
                }
            }
            ++i;
        }
    }

    public boolean convertModel(Element modelElement) throws Exception {
        boolean neededConversion = false;
        String modelXMLVersion = modelElement.getAttribute("xml-version");
        while (!XML_VERSION.equals(modelXMLVersion)) {
            XMLConverter converter;
            neededConversion = true;
            System.err.println("Model XML version mismatch: expected=\"1.0.1\" found=\"" + modelXMLVersion + "\"");
            if (modelXMLVersion.equals("")) {
                System.err.println("Defaulting XML version to \"0.0.0\"");
                modelXMLVersion = "0.0.0";
            }
            if ((converter = LegacySupportManager.getInstance().getModelConverter(modelXMLVersion)) == null) {
                System.err.println("Could not locate model converter...throwing Exception.");
                throw new Exception("Could not convert model xml to new format.");
            }
            System.err.println("Found model converter: " + converter);
            System.err.println("Starting conversion process...");
            converter.convert(modelElement);
            System.err.println("Model conversion complete.");
            String tempVersion = modelElement.getAttribute("xml-version");
            if (tempVersion.equals(modelXMLVersion)) {
                System.err.println("Conversion process failed to update xml version.");
                System.err.println("Avoiding infinite loop by throwing exception.");
                throw new Exception("Conversion process failed to update xml version.");
            }
            System.err.println("Model converted to version: \"" + tempVersion + "\"");
            modelXMLVersion = tempVersion;
        }
        NodeList elementsElementList = modelElement.getElementsByTagName("elements");
        if (elementsElementList.getLength() > 0) {
            Element elementsElement = (Element)elementsElementList.item(0);
            NodeList elementList = elementsElement.getElementsByTagName("element");
            int i = 0;
            while (i < elementList.getLength()) {
                Element elementElement = (Element)elementList.item(i);
                Properties properties = new Properties();
                NodeList propertiesList = elementElement.getElementsByTagName("properties");
                if (propertiesList.getLength() > 0) {
                    Element propertiesElement = (Element)propertiesList.item(0);
                    NodeList propertyList = propertiesElement.getElementsByTagName("property");
                    int p = 0;
                    while (p < propertyList.getLength()) {
                        Element propertyElement = (Element)propertyList.item(p);
                        properties.setProperty(propertyElement.getAttribute("name"), propertyElement.getAttribute("value"));
                        ++p;
                    }
                }
                neededConversion |= this.convertElementConfiguration(elementElement);
                ++i;
            }
        }
        return neededConversion;
    }

    public final boolean convertElementConfiguration(Element elementElement) {
        boolean neededConversion = false;
        NodeList configurationList = elementElement.getElementsByTagName("configuration");
        if (configurationList.getLength() > 0) {
            Element configurationElement = (Element)configurationList.item(0);
            NodeList managedConfigSectionList = configurationElement.getElementsByTagName("managed-config");
            boolean localNeededConversion = false;
            do {
                localNeededConversion = false;
                int c = 0;
                while (c < managedConfigSectionList.getLength()) {
                    XMLConverter converter;
                    Element configSectionElement = (Element)managedConfigSectionList.item(c);
                    String managerType = configSectionElement.getAttribute("type");
                    String xmlVersion = configSectionElement.getAttribute("xml-version");
                    if (xmlVersion.equals("")) {
                        xmlVersion = "0.0.0";
                    }
                    if ((converter = UpgradeSupportManager.getInstance().getLegacyConfigurationManagerConverter(managerType, xmlVersion, this.getDataServices())) != null) {
                        neededConversion = true;
                        localNeededConversion = true;
                        try {
                            converter.convert(configSectionElement);
                        }
                        catch (ConversionException e) {
                            e.printStackTrace();
                        }
                    }
                    ++c;
                }
                managedConfigSectionList = configurationElement.getElementsByTagName("managed-config");
            } while (localNeededConversion);
        }
        return neededConversion;
    }

    public Object getDataService(String name) {
        return this.dataServices.get(name);
    }

    public List<Object> getDataServices() {
        LinkedList<Object> ret = new LinkedList<Object>();
        ret.addAll(this.dataServices.values());
        return ret;
    }

    public void putDataService(String name, Object service) {
        this.dataServices.put(name, service);
    }
}

