/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.update.LegacyBrand;

public class LegacyBrandManager {
    private LegacyBrand defaultBrand;
    private Map<String, LegacyBrand> brandMap = new HashMap<String, LegacyBrand>();
    private Map<String, List<String>> supportedLanguages = new HashMap<String, List<String>>();
    private List<String> supportedInteractions = new ArrayList<String>();

    public LegacyBrand getDefaultBrand() {
        return this.defaultBrand;
    }

    public void setDefaultBrand(LegacyBrand defaultBrand) {
        if (this.defaultBrand != null) {
            this.brandMap.remove(this.defaultBrand.getName());
        }
        this.defaultBrand = defaultBrand;
        defaultBrand.setManager(this);
        this.brandMap.put(defaultBrand.getName(), defaultBrand);
    }

    public boolean checkBrandName(String name) {
        return this.brandMap.get(name) == null;
    }

    public LegacyBrand getBrand(String name) {
        return this.brandMap.get(name);
    }

    public List<String> getSupportedInteractionTypes() {
        return this.supportedInteractions;
    }

    public void addInteractionSupport(String interactionType) {
        if (!this.supportedInteractions.contains(interactionType)) {
            this.supportedInteractions.add(interactionType);
        }
    }

    public List<String> getSupportedLanguages(String interactionType) {
        List<String> ret = this.supportedLanguages.get(interactionType);
        if (ret == null) {
            ret = new ArrayList<String>();
        }
        return ret;
    }

    public void addSupportedLanguage(String interactionType, String language) {
        List<String> ret = this.supportedLanguages.get(interactionType);
        if (ret == null) {
            ret = new ArrayList<String>();
            this.supportedLanguages.put(interactionType, ret);
        }
        ret.remove(language);
        ret.add(language);
    }
}

