/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.update;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.XMLConverter;
import org.osgi.framework.Bundle;

public class UpgradeSupportManager {
    public static final String elementConvertsExtensionId = "org.eclipse.vtp.desktop.model.legacy.elementConverters";
    public static final String configurationManagerConvertersExtensionId = "org.eclipse.vtp.desktop.model.legacy.configurationManagerConverters";
    private static final UpgradeSupportManager INSTANCE = new UpgradeSupportManager();
    private Map<String, ElementConverter> elementConverters = new HashMap<String, ElementConverter>();
    private Map<String, ConfigurationManagerConverter> configurationManagerConverters;

    public static UpgradeSupportManager getInstance() {
        return INSTANCE;
    }

    public UpgradeSupportManager() {
        IConfigurationElement[] elementConverterExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(elementConvertsExtensionId);
        int i = 0;
        while (i < elementConverterExtensions.length) {
            String typeId = elementConverterExtensions[i].getAttribute("type");
            String version = elementConverterExtensions[i].getAttribute("version");
            String className = elementConverterExtensions[i].getAttribute("class");
            Bundle contributor = Platform.getBundle((String)elementConverterExtensions[i].getContributor().getName());
            try {
                Class converterClass = contributor.loadClass(className);
                ElementConverter lec = new ElementConverter(typeId, version, converterClass);
                this.elementConverters.put(String.valueOf(lec.typeId) + lec.version, lec);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.configurationManagerConverters = new HashMap<String, ConfigurationManagerConverter>();
        IConfigurationElement[] configurationManagerConverterExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(configurationManagerConvertersExtensionId);
        int i2 = 0;
        while (i2 < configurationManagerConverterExtensions.length) {
            String typeId = configurationManagerConverterExtensions[i2].getAttribute("type");
            String version = configurationManagerConverterExtensions[i2].getAttribute("version");
            String className = configurationManagerConverterExtensions[i2].getAttribute("class");
            Bundle contributor = Platform.getBundle((String)configurationManagerConverterExtensions[i2].getContributor().getName());
            try {
                Class converterClass = contributor.loadClass(className);
                ConfigurationManagerConverter lec = new ConfigurationManagerConverter(typeId, version, converterClass);
                this.configurationManagerConverters.put(String.valueOf(lec.typeId) + lec.version, lec);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ++i2;
        }
    }

    public XMLConverter getLegacyElementConverter(String type, String version, List<Object> dataServices) {
        String key = String.valueOf(type) + version;
        ElementConverter elementConverter = this.elementConverters.get(key);
        if (elementConverter != null) {
            return this.getConverterInstance(elementConverter.constructors, dataServices);
        }
        return null;
    }

    public XMLConverter getLegacyConfigurationManagerConverter(String type, String version, List<Object> dataServices) {
        String key = String.valueOf(type) + version;
        ConfigurationManagerConverter configurationManagerConverter = this.configurationManagerConverters.get(key);
        if (configurationManagerConverter != null) {
            return this.getConverterInstance(configurationManagerConverter.constructors, dataServices);
        }
        return null;
    }

    public XMLConverter getConverterInstance(Constructor<?>[] constructors, List<Object> dataServices) {
        try {
            int i = 0;
            while (i < constructors.length) {
                block11: {
                    Class<?>[] paramClasses = constructors[i].getParameterTypes();
                    Object[] params = new Object[paramClasses.length];
                    int c = 0;
                    while (c < paramClasses.length) {
                        if (paramClasses[c].isArray()) {
                            Class<?> arrayClass = paramClasses[c].getComponentType();
                            LinkedList<Object> paramValueList = new LinkedList<Object>();
                            int s = 0;
                            while (s < dataServices.size()) {
                                Object dataService = dataServices.get(s);
                                if (arrayClass.isAssignableFrom(dataService.getClass())) {
                                    paramValueList.add(dataService);
                                }
                                ++s;
                            }
                            params[c] = paramValueList.toArray((Object[])Array.newInstance(arrayClass, paramValueList.size()));
                        } else {
                            int s = 0;
                            while (s < dataServices.size()) {
                                Object dataService = dataServices.get(s);
                                if (paramClasses[c].isAssignableFrom(dataService.getClass())) {
                                    params[c] = dataService;
                                    break;
                                }
                                ++s;
                            }
                            if (params[c] == null) break block11;
                        }
                        ++c;
                    }
                    return (XMLConverter)constructors[i].newInstance(params);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private class ConfigurationManagerConverter {
        String typeId;
        String version;
        Class<XMLConverter> converterClass;
        Constructor<?>[] constructors = null;

        ConfigurationManagerConverter(String typeId, String version, Class<XMLConverter> converterClass) {
            this.typeId = typeId;
            this.version = version;
            this.converterClass = converterClass;
            this.constructors = this.converterClass.getConstructors();
            int i = this.constructors.length - 1;
            while (i >= 0) {
                int j = 1;
                while (j <= i) {
                    if (this.constructors[j - 1].getParameterTypes().length < this.constructors[j].getParameterTypes().length) {
                        Constructor<?> temp = this.constructors[j];
                        this.constructors[j] = this.constructors[j - 1];
                        this.constructors[j - 1] = temp;
                    }
                    ++j;
                }
                --i;
            }
        }
    }

    private class ElementConverter {
        String typeId;
        String version;
        Class<XMLConverter> converterClass;
        Constructor<?>[] constructors = null;

        ElementConverter(String typeId, String version, Class<XMLConverter> converterClass) {
            this.typeId = typeId;
            this.version = version;
            this.converterClass = converterClass;
            this.constructors = this.converterClass.getConstructors();
            int i = this.constructors.length - 1;
            while (i >= 0) {
                int j = 1;
                while (j <= i) {
                    if (this.constructors[j - 1].getParameterTypes().length < this.constructors[j].getParameterTypes().length) {
                        Constructor<?> temp = this.constructors[j];
                        this.constructors[j] = this.constructors[j - 1];
                        this.constructors[j - 1] = temp;
                    }
                    ++j;
                }
                --i;
            }
        }
    }
}

