/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowProject;
import org.eclipse.vtp.desktop.model.core.internal.branding.Brand;
import org.eclipse.vtp.desktop.model.core.internal.branding.DefaultBrandManager;
import org.eclipse.vtp.desktop.projects.core.util.BrandConfigurationScreen;
import org.eclipse.vtp.desktop.projects.core.util.ConfigurationBrandManager;
import org.eclipse.vtp.framework.util.Guid;

public class WorkflowProjectConfigurationPropertyPage
extends PropertyPage {
    private BrandConfigurationScreen screen = new BrandConfigurationScreen();
    private WorkflowProject applicationProject = null;
    private ConfigurationBrandManager brandManager = null;

    public WorkflowProjectConfigurationPropertyPage() {
        DefaultBrandManager defaultManager = new DefaultBrandManager();
        defaultManager.setDefaultBrand((IBrand)new Brand(Guid.createGUID(), "Default"));
        this.brandManager = new ConfigurationBrandManager((BrandManager)defaultManager);
        this.screen.init((BrandManager)this.brandManager);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(IAdaptable element) {
        super.setElement(element);
        try {
            if (element instanceof WorkflowProject) {
                this.applicationProject = (WorkflowProject)element;
            } else {
                if (!(element instanceof IProject)) throw new RuntimeException("Unsupported element type");
                IProject project = (IProject)element;
                if (!WorkflowCore.getDefault().getWorkflowModel().isWorkflowProject(project)) throw new RuntimeException("Unsupported element type");
                this.applicationProject = (WorkflowProject)WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowProject(project);
            }
            this.brandManager = new ConfigurationBrandManager(this.applicationProject.getBrandManager());
            this.screen.init((BrandManager)this.brandManager);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FillLayout());
        this.screen.createContents(comp);
        return comp;
    }

    protected void performDefaults() {
        if (this.applicationProject != null) {
            this.brandManager = new ConfigurationBrandManager(this.applicationProject.getBrandManager());
        } else {
            DefaultBrandManager defaultManager = new DefaultBrandManager();
            defaultManager.setDefaultBrand((IBrand)new Brand(Guid.createGUID(), "Default"));
            this.brandManager = new ConfigurationBrandManager((BrandManager)defaultManager);
        }
        this.screen.init((BrandManager)this.brandManager);
        super.performDefaults();
    }

    public boolean performOk() {
        this.brandManager.saveTo(this.applicationProject.getBrandManager(), false);
        this.applicationProject.storeBuildPath();
        return true;
    }
}

