/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.internal.branding.Brand;
import org.eclipse.vtp.desktop.projects.core.dialogs.BrandDialog;
import org.eclipse.vtp.framework.util.Guid;

public class BrandConfigurationScreen {
    private TreeViewer brandViewer = null;
    private BrandManager brands = null;

    public void init(BrandManager brandManager) {
        this.brands = brandManager;
    }

    public Control createContents(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm sf = toolkit.createScrolledForm(parent);
        Composite comp = sf.getForm().getBody();
        comp.setLayout((Layout)new GridLayout());
        comp.setBackground(parent.getBackground());
        Section brandSection = toolkit.createSection(comp, 256);
        GridData gridData = new GridData(768);
        brandSection.setLayoutData((Object)gridData);
        brandSection.setText("Brands");
        this.brandViewer = new TreeViewer(comp, 67588);
        this.brandViewer.setContentProvider((IContentProvider)new BrandContentProvider());
        this.brandViewer.setLabelProvider((IBaseLabelProvider)new BrandLabelProvider());
        this.brandViewer.setInput((Object)this);
        GridData gridData2 = new GridData(768);
        gridData2.minimumHeight = 125;
        gridData2.heightHint = 125;
        this.brandViewer.getControl().setLayoutData((Object)gridData2);
        this.hookContextMenu();
        return comp;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BrandConfigurationScreen.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.brandViewer.getControl());
        this.brandViewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection sel = (IStructuredSelection)this.brandViewer.getSelection();
        if (!sel.isEmpty()) {
            final IBrand brand = (IBrand)sel.getFirstElement();
            manager.add((IAction)new Action("Add Brand"){

                public void run() {
                    Shell workbenchShell = Display.getCurrent().getActiveShell();
                    BrandDialog bd = new BrandDialog(workbenchShell);
                    bd.setReservedNames(BrandConfigurationScreen.this.getBrandNames(brand));
                    if (bd.open() == 0) {
                        Brand nbrand = new Brand(Guid.createGUID(), bd.getBrandName());
                        nbrand.setParent(brand);
                        BrandConfigurationScreen.this.brandViewer.refresh((Object)brand);
                        BrandConfigurationScreen.this.brandViewer.reveal((Object)nbrand);
                    }
                }
            });
            if (!this.brands.getDefaultBrand().getId().equals(brand.getId())) {
                manager.add((IAction)new Action("Remove Brand"){

                    public void run() {
                        IBrand parentBrand = brand.getParent();
                        brand.delete();
                        BrandConfigurationScreen.this.brandViewer.refresh((Object)parentBrand);
                    }
                });
            }
        }
    }

    private List<String> getBrandNames(IBrand brand) {
        ArrayList<String> ret = new ArrayList<String>();
        for (IBrand child : brand.getChildBrands()) {
            ret.add(child.getName());
        }
        return ret;
    }

    private class BrandContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private BrandContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{BrandConfigurationScreen.this.brands.getDefaultBrand()};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return ((IBrand)parentElement).getChildBrands().toArray();
        }

        public Object getParent(Object element) {
            return ((IBrand)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((IBrand)element).getChildBrands().size() > 0;
        }
    }

    private class BrandLabelProvider
    extends LabelProvider {
        private BrandLabelProvider() {
        }

        public String getText(Object element) {
            return ((IBrand)element).getName();
        }
    }
}

