/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.util;

import java.util.HashMap;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.internal.branding.Brand;
import org.eclipse.vtp.desktop.model.core.internal.branding.DefaultBrandManager;

public class ConfigurationBrandManager
extends DefaultBrandManager {
    public ConfigurationBrandManager(BrandManager sourceManager) {
        IBrand sourceDefault = sourceManager.getDefaultBrand();
        Brand copyDefault = new Brand(sourceDefault.getId(), sourceDefault.getName());
        this.setDefaultBrand((IBrand)copyDefault);
        this.copyBrands(sourceDefault, copyDefault);
    }

    private void copyBrands(IBrand sourceBrand, Brand copyBrand) {
        List sourceChildren = sourceBrand.getChildBrands();
        for (IBrand sourceChild : sourceChildren) {
            Brand copyChild = new Brand(sourceChild.getId(), sourceChild.getName());
            copyChild.setParent((IBrand)copyBrand);
            this.copyBrands(sourceChild, copyChild);
        }
    }

    public void saveTo(BrandManager destinationManager) {
        this.saveTo(destinationManager, false);
    }

    public void saveTo(BrandManager destinationManager, boolean overwrite) {
        Brand destinationDefault = (Brand)destinationManager.getDefaultBrand();
        Brand copyDefault = (Brand)this.getDefaultBrand();
        if (overwrite) {
            ((DefaultBrandManager)destinationManager).setDefaultBrand((IBrand)copyDefault);
        } else {
            this.mergeBrand(copyDefault, destinationDefault);
        }
    }

    private void mergeBrand(Brand copyBrand, Brand destinationBrand) {
        HashMap<String, Brand> copyBrandIndex = new HashMap<String, Brand>();
        for (IBrand copyChild : copyBrand.getChildBrands()) {
            copyBrandIndex.put(copyChild.getId(), (Brand)copyChild);
        }
        HashMap<String, Brand> destinationBrandIndex = new HashMap<String, Brand>();
        for (IBrand destinationChild : destinationBrand.getChildBrands()) {
            destinationBrandIndex.put(destinationChild.getId(), (Brand)destinationChild);
        }
        for (IBrand copyChild : copyBrand.getChildBrands()) {
            Brand destinationChild = (Brand)destinationBrandIndex.get(copyChild.getId());
            if (destinationChild == null) {
                copyChild.setParent((IBrand)destinationBrand);
                continue;
            }
            this.mergeBrand((Brand)copyChild, destinationChild);
        }
        for (IBrand destinationChild : destinationBrand.getChildBrands()) {
            Brand copyChild = (Brand)copyBrandIndex.get(destinationChild.getId());
            if (copyChild != null) continue;
            destinationChild.delete();
        }
    }
}

