/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.view;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.ide.ResourceSelectionUtil;

public class RefactorActionGroup
extends ActionGroup {
    private RenameResourceAction renameAction;
    private Shell shell;
    private Tree tree;

    public RefactorActionGroup(Shell aShell, Tree aTree) {
        this.shell = aShell;
        this.tree = aTree;
        this.makeActions();
    }

    public void fillContextMenu(IMenuManager menu) {
        boolean anyResourceSelected;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean bl = anyResourceSelected = !(selection = new StructuredSelection(((IAdaptable)selection.getFirstElement()).getAdapter(IResource.class))).isEmpty() && ResourceSelectionUtil.allResourcesAreOfType((IStructuredSelection)selection, (int)7);
        if (anyResourceSelected) {
            this.renameAction.selectionChanged(selection);
            menu.appendToGroup("group.reorganize", (IAction)this.renameAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        this.updateActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.keyCode == 0x100000B && event.stateMask == 0) {
            if (this.renameAction.isEnabled()) {
                this.renameAction.run();
            }
            event.doit = false;
        }
    }

    protected void makeActions() {
        IShellProvider sp = new IShellProvider(){

            public Shell getShell() {
                return RefactorActionGroup.this.shell;
            }
        };
        this.renameAction = new RenameResourceAction(sp, this.tree);
        this.renameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        selection = new StructuredSelection(((IAdaptable)selection.getFirstElement()).getAdapter(IResource.class));
        this.renameAction.selectionChanged(selection);
    }
}

