/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.view;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.IWorkflowResourceContainer;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;

public class WorkflowProjectContentProvider
implements IPipelinedTreeContentProvider,
IDoubleClickListener {
    private Viewer viewer = null;

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProject) {
            IWorkflowProject workflowProject = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowProject((IProject)parentElement);
            return workflowProject.getChildren().toArray();
        }
        if (parentElement instanceof IWorkflowResourceContainer) {
            return ((IWorkflowResourceContainer)parentElement).getChildren().toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof IProject) {
            return ((IProject)element).getWorkspace().getRoot();
        }
        if (element instanceof IWorkflowResource) {
            IWorkflowResource con = ((IWorkflowResource)element).getParent();
            if (con instanceof IWorkflowProject) {
                return con.getAdapter(IResource.class);
            }
            return con;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IProject) {
            return true;
        }
        if (element instanceof IDesignDocument) {
            return false;
        }
        return element instanceof IWorkflowResourceContainer;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            return ((IWorkspaceRoot)inputElement).getProjects();
        }
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.viewer != null) {
            ((CommonViewer)this.viewer).removeDoubleClickListener((IDoubleClickListener)this);
        }
        this.viewer = viewer;
        if (viewer != null) {
            ((CommonViewer)this.viewer).addDoubleClickListener((IDoubleClickListener)this);
        }
    }

    public void getPipelinedChildren(Object aParent, Set theCurrentChildren) {
        LinkedList<IWorkflowResource> newChildren = new LinkedList<IWorkflowResource>();
        if (aParent instanceof IProject) {
            IProject project = (IProject)aParent;
            try {
                if (WorkflowCore.getDefault().getWorkflowModel().isWorkflowProject(project)) {
                    IWorkflowProject workflowProject = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowProject(project);
                    List workflowResources = workflowProject.getChildren();
                    Iterator iterator = theCurrentChildren.iterator();
                    block2: while (iterator.hasNext()) {
                        Object child = iterator.next();
                        if (!(child instanceof IResource)) continue;
                        IResource resource = (IResource)child;
                        for (IWorkflowResource workflowResource : workflowResources) {
                            if (!workflowResource.getName().equals(resource.getName())) continue;
                            iterator.remove();
                            newChildren.add(workflowResource);
                            continue block2;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        theCurrentChildren.addAll(newChildren);
    }

    public void getPipelinedElements(Object anInput, Set theCurrentElements) {
        this.getPipelinedChildren(anInput, theCurrentElements);
    }

    public Object getPipelinedParent(Object anObject, Object aSuggestedParent) {
        if (aSuggestedParent instanceof IResource) {
            IResource resource = (IResource)aSuggestedParent;
            IWorkflowResource workflowResource = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowResource(resource);
            if (workflowResource != null && !(workflowResource instanceof IWorkflowProject)) {
                return workflowResource;
            }
        }
        return aSuggestedParent;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        Object parentObj = anAddModification.getParent();
        if (parentObj instanceof IResource) {
            IResource parent = (IResource)parentObj;
            IWorkflowResource workflowParent = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowResource(parent);
            if (workflowParent != null && !(workflowParent instanceof IWorkflowProject)) {
                anAddModification.setParent((Object)workflowParent);
            }
            Set children = anAddModification.getChildren();
            LinkedList<IWorkflowResource> newChildren = new LinkedList<IWorkflowResource>();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                Object childObj = iterator.next();
                if (!(childObj instanceof IResource)) continue;
                IResource childResource = (IResource)childObj;
                IWorkflowResource workflowChild = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowResource(childResource);
                if (workflowChild == null) continue;
                iterator.remove();
                newChildren.add(workflowChild);
            }
            children.addAll(newChildren);
        }
        return anAddModification;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        boolean changed = false;
        Set children = aRefreshSynchronization.getRefreshTargets();
        LinkedList<IWorkflowResource> newTargets = new LinkedList<IWorkflowResource>();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            Object childObj = iterator.next();
            if (!(childObj instanceof IResource)) continue;
            IResource childResource = (IResource)childObj;
            IWorkflowResource workflowChild = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowResource(childResource);
            if (workflowChild == null) continue;
            iterator.remove();
            newTargets.add(workflowChild);
            changed = true;
        }
        children.addAll(newTargets);
        return changed;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        Set children = aRemoveModification.getChildren();
        final LinkedList<IWorkflowResource> parents = new LinkedList<IWorkflowResource>();
        for (Object childObj : children) {
            if (!(childObj instanceof IResource)) continue;
            IResource childResource = (IResource)childObj;
            IWorkflowResource workflowParent = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowResource((IResource)childResource.getParent());
            if (workflowParent == null) continue;
            parents.add(workflowParent);
        }
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (IWorkflowResource parent : parents) {
                    ((TreeViewer)WorkflowProjectContentProvider.this.viewer).refresh((Object)parent);
                }
            }
        });
        return aRemoveModification;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        return false;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void doubleClick(DoubleClickEvent event) {
        IFile underlyingFile;
        IResource resource;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object sel = selection.getFirstElement();
        if (sel instanceof IAdaptable && (resource = (IResource)((IAdaptable)sel).getAdapter(IResource.class)) instanceof IFile && (underlyingFile = (IFile)resource) != null) {
            try {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)underlyingFile);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }
}

