/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.vtp.desktop.model.core.IDatabase;
import org.eclipse.vtp.desktop.model.core.IDatabaseTable;

public class CreateDatabaseTableWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IDatabase database = null;
    private DatabaseWizardPage bwp = new DatabaseWizardPage();
    IConfigurationElement configElement = null;

    public CreateDatabaseTableWizard() {
        this.addPage((IWizardPage)this.bwp);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object obj;
        if (selection.isEmpty()) {
            try {
                selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((obj = selection.getFirstElement()) instanceof IDatabase) {
            this.database = (IDatabase)obj;
        } else if (obj instanceof IDatabaseTable) {
            this.database = (IDatabase)((IDatabaseTable)obj).getParent();
        }
    }

    public boolean performFinish() {
        try {
            IDatabaseTable table = this.database.createTable(this.bwp.brandNameField.getText());
            this.database.refresh();
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)table.getUnderlyingFile());
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    private class DatabaseWizardPage
    extends WizardPage {
        Text brandNameField;

        public DatabaseWizardPage() {
            super("DatabaseTablePage", "Enter a name for the database table", null);
            this.brandNameField = null;
        }

        public void createControl(Composite parent) {
            this.setPageComplete(false);
            Composite comp = new Composite(parent, 0);
            Label brandNameLabel = new Label(comp, 0);
            brandNameLabel.setText("Table Name:");
            brandNameLabel.setSize(brandNameLabel.computeSize(-1, -1));
            this.brandNameField = new Text(comp, 2052);
            this.brandNameField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String text = e.text;
                    char[] chars = text.toCharArray();
                    String currentName = String.valueOf(DatabaseWizardPage.this.brandNameField.getText().substring(0, e.start)) + e.text + DatabaseWizardPage.this.brandNameField.getText(e.end, DatabaseWizardPage.this.brandNameField.getText().length() - 1);
                    if (currentName.length() > 255) {
                        e.doit = false;
                        return;
                    }
                    int i = 0;
                    while (i < chars.length) {
                        if (!Character.isLetterOrDigit(chars[i]) && chars[i] != '$' && chars[i] != '_') {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
            this.brandNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String n = DatabaseWizardPage.this.brandNameField.getText();
                    for (IDatabaseTable dt : CreateDatabaseTableWizard.this.database.getTables()) {
                        if (!dt.getName().equals(n)) continue;
                        DatabaseWizardPage.this.setErrorMessage("A Database Table already exists with that name.");
                        DatabaseWizardPage.this.setPageComplete(false);
                        return;
                    }
                    DatabaseWizardPage.this.setErrorMessage(null);
                    DatabaseWizardPage.this.setPageComplete(true);
                }
            });
            comp.setLayout((Layout)new FormLayout());
            FormData brandNameLabelData = new FormData();
            brandNameLabelData.left = new FormAttachment(0, 10);
            brandNameLabelData.top = new FormAttachment(0, 30);
            brandNameLabelData.right = new FormAttachment(0, 10 + brandNameLabel.getSize().x);
            brandNameLabelData.bottom = new FormAttachment(0, 30 + brandNameLabel.getSize().y);
            brandNameLabel.setLayoutData((Object)brandNameLabelData);
            FormData brandNameFieldData = new FormData();
            brandNameFieldData.left = new FormAttachment((Control)brandNameLabel, 10);
            brandNameFieldData.top = new FormAttachment(0, 29);
            brandNameFieldData.right = new FormAttachment(100, -10);
            this.brandNameField.setLayoutData((Object)brandNameFieldData);
            this.setControl((Control)comp);
        }
    }
}

