/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.wizards;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IDesignItemContainer;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;

public class CreateWorkflowDesignDocumentWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IDesignItemContainer designItemContainer = null;
    private DesignDocumentWizardPage bwp = new DesignDocumentWizardPage();
    IConfigurationElement configElement = null;

    public CreateWorkflowDesignDocumentWizard() {
        this.addPage((IWizardPage)this.bwp);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object obj = selection.getFirstElement();
        if (obj == null) {
            obj = ((IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection()).getFirstElement();
        }
        if (obj instanceof IDesignItemContainer) {
            this.designItemContainer = (IDesignItemContainer)obj;
        } else if (obj instanceof IDesignDocument) {
            this.designItemContainer = ((IDesignDocument)obj).getParentDesignContainer();
        } else if (obj instanceof IWorkflowProject) {
            this.designItemContainer = ((IWorkflowProject)obj).getDesignRootFolder();
        }
    }

    public boolean performFinish() {
        IDesignDocument bo = this.designItemContainer.createDesignDocument(this.bwp.documentNameField.getText());
        if (bo != null) {
            this.designItemContainer.refresh();
            return true;
        }
        return false;
    }

    private class DesignDocumentWizardPage
    extends WizardPage {
        Text documentNameField;

        public DesignDocumentWizardPage() {
            super("DesignDocumentPage", "Enter a name for the new design document.  The \".canvas\" file extension will automatically be added to the name you provide.", null);
            this.documentNameField = null;
        }

        public void createControl(Composite parent) {
            this.setPageComplete(false);
            Composite comp = new Composite(parent, 0);
            Label folderNameLabel = new Label(comp, 0);
            folderNameLabel.setText("Name:");
            folderNameLabel.setSize(folderNameLabel.computeSize(-1, -1));
            this.documentNameField = new Text(comp, 2052);
            this.documentNameField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String text = e.text;
                    char[] chars = text.toCharArray();
                    String currentName = String.valueOf(DesignDocumentWizardPage.this.documentNameField.getText().substring(0, e.start)) + e.text + DesignDocumentWizardPage.this.documentNameField.getText(e.end, DesignDocumentWizardPage.this.documentNameField.getText().length() - 1);
                    if (currentName.length() > 255) {
                        e.doit = false;
                        return;
                    }
                    int i = 0;
                    while (i < chars.length) {
                        if (!Character.isLetterOrDigit(chars[i]) && chars[i] != '$' && chars[i] != '_' && chars[i] != '.') {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
            this.documentNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String n = DesignDocumentWizardPage.this.documentNameField.getText();
                    for (IWorkflowResource wr : CreateWorkflowDesignDocumentWizard.this.designItemContainer.getChildren()) {
                        if (!wr.getName().equals(n)) continue;
                        DesignDocumentWizardPage.this.setErrorMessage("A design document already exists with that name.");
                        DesignDocumentWizardPage.this.setPageComplete(false);
                        return;
                    }
                    DesignDocumentWizardPage.this.setErrorMessage(null);
                    DesignDocumentWizardPage.this.setPageComplete(true);
                }
            });
            comp.setLayout((Layout)new FormLayout());
            FormData folderNameLabelData = new FormData();
            folderNameLabelData.left = new FormAttachment(0, 10);
            folderNameLabelData.top = new FormAttachment(0, 30);
            folderNameLabelData.right = new FormAttachment(0, 10 + folderNameLabel.getSize().x);
            folderNameLabelData.bottom = new FormAttachment(0, 30 + folderNameLabel.getSize().y);
            folderNameLabel.setLayoutData((Object)folderNameLabelData);
            FormData brandNameFieldData = new FormData();
            brandNameFieldData.left = new FormAttachment((Control)folderNameLabel, 10);
            brandNameFieldData.top = new FormAttachment(0, 29);
            brandNameFieldData.right = new FormAttachment(100, -10);
            this.documentNameField.setLayoutData((Object)brandNameFieldData);
            this.setControl((Control)comp);
        }
    }
}

