/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.wizards;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IDesignFolder;
import org.eclipse.vtp.desktop.model.core.IDesignItemContainer;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;

public class CreateWorkflowDesignFolderWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IDesignItemContainer designItemContainer = null;
    private DesignFolderWizardPage bwp = new DesignFolderWizardPage();
    IConfigurationElement configElement = null;

    public CreateWorkflowDesignFolderWizard() {
        this.addPage((IWizardPage)this.bwp);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object obj = selection.getFirstElement();
        if (obj == null) {
            obj = ((IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection()).getFirstElement();
        }
        if (obj instanceof IDesignItemContainer) {
            this.designItemContainer = (IDesignItemContainer)obj;
        } else if (obj instanceof IDesignDocument) {
            this.designItemContainer = ((IDesignDocument)obj).getParentDesignContainer();
        } else if (obj instanceof IWorkflowProject) {
            this.designItemContainer = ((IWorkflowProject)obj).getDesignRootFolder();
        }
    }

    public boolean performFinish() {
        IDesignFolder bo = this.designItemContainer.createDesignFolder(this.bwp.folderNameField.getText());
        if (bo != null) {
            this.designItemContainer.refresh();
            return true;
        }
        return false;
    }

    private class DesignFolderWizardPage
    extends WizardPage {
        Text folderNameField;

        public DesignFolderWizardPage() {
            super("DesignFolderPage", "Enter a name for the new design folder", null);
            this.folderNameField = null;
        }

        public void createControl(Composite parent) {
            this.setPageComplete(false);
            Composite comp = new Composite(parent, 0);
            Label folderNameLabel = new Label(comp, 0);
            folderNameLabel.setText("Name:");
            folderNameLabel.setSize(folderNameLabel.computeSize(-1, -1));
            this.folderNameField = new Text(comp, 2052);
            this.folderNameField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String text = e.text;
                    char[] chars = text.toCharArray();
                    String currentName = String.valueOf(DesignFolderWizardPage.this.folderNameField.getText().substring(0, e.start)) + e.text + DesignFolderWizardPage.this.folderNameField.getText(e.end, DesignFolderWizardPage.this.folderNameField.getText().length() - 1);
                    if (currentName.length() > 255) {
                        e.doit = false;
                        return;
                    }
                    int i = 0;
                    while (i < chars.length) {
                        if (!Character.isLetterOrDigit(chars[i]) && chars[i] != '$' && chars[i] != '_' && chars[i] != '.') {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
            this.folderNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String n = DesignFolderWizardPage.this.folderNameField.getText();
                    for (IWorkflowResource wr : CreateWorkflowDesignFolderWizard.this.designItemContainer.getChildren()) {
                        if (!wr.getName().equals(n)) continue;
                        DesignFolderWizardPage.this.setErrorMessage("A design filder already exists with that name.");
                        DesignFolderWizardPage.this.setPageComplete(false);
                        return;
                    }
                    DesignFolderWizardPage.this.setErrorMessage(null);
                    DesignFolderWizardPage.this.setPageComplete(true);
                }
            });
            comp.setLayout((Layout)new FormLayout());
            FormData folderNameLabelData = new FormData();
            folderNameLabelData.left = new FormAttachment(0, 10);
            folderNameLabelData.top = new FormAttachment(0, 30);
            folderNameLabelData.right = new FormAttachment(0, 10 + folderNameLabel.getSize().x);
            folderNameLabelData.bottom = new FormAttachment(0, 30 + folderNameLabel.getSize().y);
            folderNameLabel.setLayoutData((Object)folderNameLabelData);
            FormData brandNameFieldData = new FormData();
            brandNameFieldData.left = new FormAttachment((Control)folderNameLabel, 10);
            brandNameFieldData.top = new FormAttachment(0, 29);
            brandNameFieldData.right = new FormAttachment(100, -10);
            this.folderNameField.setLayoutData((Object)brandNameFieldData);
            this.setControl((Control)comp);
        }
    }
}

