/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowProject;
import org.eclipse.vtp.desktop.model.core.internal.branding.Brand;
import org.eclipse.vtp.desktop.model.core.internal.branding.DefaultBrandManager;
import org.eclipse.vtp.desktop.projects.core.util.BrandConfigurationScreen;
import org.eclipse.vtp.desktop.projects.core.util.ConfigurationBrandManager;
import org.eclipse.vtp.framework.util.Guid;

public class CreateWorkflowProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    ApplicationPage applicationPage = null;
    BuildPathPage buildPathPage = null;
    IConfigurationElement configElement = null;
    private ConfigurationBrandManager brandManager = null;

    public CreateWorkflowProjectWizard() {
        DefaultBrandManager defaultManager = new DefaultBrandManager();
        defaultManager.setDefaultBrand((IBrand)new Brand(Guid.createGUID(), "Default"));
        this.brandManager = new ConfigurationBrandManager((BrandManager)defaultManager);
        this.applicationPage = new ApplicationPage();
        this.buildPathPage = new BuildPathPage();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.applicationPage);
        this.addPage((IWizardPage)this.buildPathPage);
    }

    public boolean performFinish() {
        WorkflowProject workflowProject = (WorkflowProject)WorkflowCore.getDefault().getWorkflowModel().createWorkflowProject("org.eclipse.vtp.desktop.model.core.WorkflowProjectNature", this.applicationPage.nameField.getText());
        this.buildPathPage.configureBuildPath((IWorkflowProject)workflowProject);
        workflowProject.storeBuildPath();
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean canFinish() {
        return ((Object)((Object)this.buildPathPage)).equals(this.getContainer().getCurrentPage());
    }

    public class ApplicationPage
    extends WizardPage {
        Text nameField;

        public ApplicationPage() {
            super("CreateApplicationPage", "Create Application", null);
            this.nameField = null;
            this.setPageComplete(false);
        }

        public void createControl(Composite parent) {
            Composite comp = new Composite(parent, 0);
            comp.setBackground(parent.getDisplay().getSystemColor(1));
            this.setControl((Control)comp);
            Label hostLabel = new Label(comp, 0);
            hostLabel.setBackground(comp.getBackground());
            hostLabel.setText("Application Name:");
            hostLabel.setSize(hostLabel.computeSize(-1, -1));
            this.nameField = new Text(comp, 2052);
            this.nameField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String text = e.text;
                    char[] chars = text.toCharArray();
                    String currentName = String.valueOf(ApplicationPage.this.nameField.getText().substring(0, e.start)) + e.text + ApplicationPage.this.nameField.getText(e.end, ApplicationPage.this.nameField.getText().length() - 1);
                    if (currentName.length() > 255) {
                        e.doit = false;
                        return;
                    }
                    int i = 0;
                    while (i < chars.length) {
                        if (!Character.isLetterOrDigit(chars[i]) && chars[i] != '$' && chars[i] != '_') {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
            this.nameField.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    if (ApplicationPage.this.nameField.getText().length() == 0) {
                        ApplicationPage.this.setPageComplete(false);
                    } else {
                        IProject[] existingProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int i = 0;
                        while (i < existingProjects.length) {
                            if (ApplicationPage.this.nameField.getText().equalsIgnoreCase(existingProjects[i].getName())) {
                                ApplicationPage.this.setPageComplete(false);
                                ApplicationPage.this.setErrorMessage("Another project already exists with that name.");
                                return;
                            }
                            ++i;
                        }
                        ApplicationPage.this.setPageComplete(true);
                        ApplicationPage.this.setErrorMessage(null);
                    }
                }
            });
            FormLayout formLayout = new FormLayout();
            formLayout.marginHeight = 10;
            formLayout.marginWidth = 10;
            comp.setLayout((Layout)formLayout);
            FormData hostLabelFormData = new FormData();
            hostLabelFormData.left = new FormAttachment(0, 10);
            hostLabelFormData.top = new FormAttachment(0, 10);
            hostLabelFormData.right = new FormAttachment(0, 10 + hostLabel.getSize().x);
            hostLabelFormData.bottom = new FormAttachment(0, 10 + hostLabel.getSize().y);
            hostLabel.setLayoutData((Object)hostLabelFormData);
            FormData hostFieldFormData = new FormData();
            hostFieldFormData.left = new FormAttachment((Control)hostLabel, 6);
            hostFieldFormData.top = new FormAttachment(0, 10);
            hostFieldFormData.right = new FormAttachment(100, -10);
            this.nameField.setLayoutData((Object)hostFieldFormData);
        }

        public String getApplicationName() {
            return this.nameField.getText();
        }
    }

    public class BuildPathPage
    extends WizardPage {
        BrandConfigurationScreen screen;

        public BuildPathPage() {
            super("ConfigureBuildPathPage", "Branding", null);
            this.screen = new BrandConfigurationScreen();
            this.screen.init((BrandManager)CreateWorkflowProjectWizard.this.brandManager);
            this.setPageComplete(true);
        }

        public void createControl(Composite parent) {
            this.setControl(this.screen.createContents(parent));
        }

        void configureBuildPath(IWorkflowProject project) {
            CreateWorkflowProjectWizard.this.brandManager.saveTo(project.getBrandManager(), true);
        }
    }
}

