/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.interactive.core.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.vtp.desktop.model.interactive.core.internal.InteractionTypeSupport;
import org.eclipse.vtp.desktop.model.interactive.core.internal.LanguageSupport;
import org.eclipse.vtp.desktop.projects.interactive.core.dialogs.LanguageDialog;

public class LanguageConfigurationDialog
extends Dialog {
    private Shell parentShell = null;
    private TableViewer languageViewer = null;
    private List<String> languages = new ArrayList<String>();
    private InteractionTypeSupport support = null;

    public LanguageConfigurationDialog(Shell parentShell) {
        super(parentShell);
        this.parentShell = parentShell;
    }

    public void setCurrentSupport(InteractionTypeSupport its) {
        this.support = its;
        for (LanguageSupport ls : its.getSupportedLanguages()) {
            this.languages.add(ls.getLanguage());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Table table = new Table(comp, 67588);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        table.setLayout((Layout)tableLayout);
        TableColumn col = new TableColumn(table, 0);
        GridData gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        this.languageViewer = new TableViewer(table);
        this.languageViewer.setContentProvider((IContentProvider)new LanguageContentProvider());
        this.languageViewer.setLabelProvider((IBaseLabelProvider)new LanguageLabelProvider());
        this.languageViewer.setInput((Object)this);
        Composite buttonComp = new Composite(comp, 0);
        gd = new GridData(1040);
        buttonComp.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        buttonComp.setLayout((Layout)layout);
        Button addButton = new Button(buttonComp, 8);
        addButton.setText("Add Language");
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                LanguageDialog dialog = new LanguageDialog(LanguageConfigurationDialog.this.parentShell);
                dialog.setReservedNames(LanguageConfigurationDialog.this.languages);
                if (dialog.open() == 0) {
                    LanguageConfigurationDialog.this.languages.add(dialog.getName());
                    LanguageConfigurationDialog.this.languageViewer.refresh();
                }
            }
        });
        final Button removeButton = new Button(buttonComp, 8);
        removeButton.setText("Remove Language");
        removeButton.setEnabled(false);
        removeButton.setLayoutData((Object)new GridData());
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                LanguageConfigurationDialog.this.languages.remove(((IStructuredSelection)LanguageConfigurationDialog.this.languageViewer.getSelection()).getFirstElement());
                LanguageConfigurationDialog.this.languageViewer.refresh();
            }
        });
        this.languageViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabled = !event.getSelection().isEmpty();
                removeButton.setEnabled(enabled);
            }
        });
        return comp;
    }

    protected void okPressed() {
        List originalSupport = this.support.getSupportedLanguages();
        for (LanguageSupport languageSupport : originalSupport) {
            if (this.languages.contains(languageSupport.getLanguage())) continue;
            this.support.removeLanguageSupport(languageSupport.getLanguage());
        }
        block1: for (String string : this.languages) {
            for (LanguageSupport ls : originalSupport) {
                if (ls.getLanguage().equals(string)) continue block1;
            }
            this.support.addLanguageSupport(string);
        }
        super.okPressed();
    }

    public class LanguageContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return LanguageConfigurationDialog.this.languages.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class LanguageLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return element.toString();
        }
    }
}

