/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.interactive.core.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.framework.util.VariableNameValidator;

public class LanguageDialog
extends Dialog {
    String name = null;
    Text nameText = null;
    Button okButton = null;
    List<String> reservedNames = new ArrayList<String>();

    public LanguageDialog(Shell parentShell) {
        super(parentShell);
    }

    public LanguageDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        LanguageDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.buttonBar = this.createButtonBar(composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar.moveBelow(null);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText("Name");
        nameLabel.setLayoutData((Object)new GridData());
        this.nameText = new Text(parent, 0x800804);
        if (this.name != null) {
            this.nameText.setText(this.name);
        }
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String currentName = String.valueOf(LanguageDialog.this.nameText.getText().substring(0, e.start)) + e.text + LanguageDialog.this.nameText.getText(e.end, LanguageDialog.this.nameText.getText().length() - 1);
                if (VariableNameValidator.followsVtpNamingRules((String)currentName).booleanValue()) {
                    LanguageDialog.this.nameText.setForeground(LanguageDialog.this.nameText.getDisplay().getSystemColor(2));
                    LanguageDialog.this.okButton.setEnabled(true);
                    if (LanguageDialog.this.reservedNames.contains(currentName)) {
                        LanguageDialog.this.nameText.setForeground(LanguageDialog.this.nameText.getDisplay().getSystemColor(3));
                        LanguageDialog.this.okButton.setEnabled(false);
                    }
                } else {
                    LanguageDialog.this.nameText.setForeground(LanguageDialog.this.nameText.getDisplay().getSystemColor(3));
                    LanguageDialog.this.okButton.setEnabled(false);
                }
            }
        });
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(!this.reservedNames.contains(this.nameText.getText()) && VariableNameValidator.followsVtpNamingRules((String)this.nameText.getText()) != false);
        return parent;
    }

    protected void okPressed() {
        this.name = this.nameText.getText();
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.nameText != null) {
            this.nameText.setText(name);
        }
    }

    public void setReservedNames(List<String> reservedNames) {
        this.reservedNames = new ArrayList<String>();
        this.reservedNames.addAll(reservedNames);
    }
}

