/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.interactive.core.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.vtp.desktop.media.core.IMediaDefaultPanel;
import org.eclipse.vtp.desktop.media.core.MediaDefaultsPanelManager;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionType;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionTypeManager;
import org.eclipse.vtp.desktop.model.interactive.core.internal.InteractiveWorkflowProject;
import org.eclipse.vtp.desktop.model.interactive.core.mediadefaults.IMediaDefaultSettings;

public class ApplicationProjectMediaDefaultsPropertyPage
extends PropertyPage {
    private InteractiveWorkflowProject applicationProject = null;
    private IMediaDefaultSettings mediaDefaultSettings = null;
    ScrolledComposite scrollComp = null;
    Composite stackComp = null;
    StackLayout stack = null;
    Combo interactionSelector = null;
    List<InteractionType> interactionTypes = null;
    List<Composite> interactionComposites = new ArrayList<Composite>();
    List<IMediaDefaultPanel> settingPanels = new ArrayList<IMediaDefaultPanel>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(IAdaptable element) {
        super.setElement(element);
        try {
            if (element instanceof InteractiveWorkflowProject) {
                this.applicationProject = (InteractiveWorkflowProject)element;
            } else {
                if (!(element instanceof IProject)) throw new RuntimeException("Unsupported element type");
                IProject project = (IProject)element;
                if (!WorkflowCore.getDefault().getWorkflowModel().isWorkflowProject(project)) throw new RuntimeException("Unsupported element type");
                IWorkflowProject workflowProject = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowProject(project);
                if (workflowProject instanceof InteractiveWorkflowProject) {
                    this.applicationProject = (InteractiveWorkflowProject)workflowProject;
                }
            }
            this.mediaDefaultSettings = this.applicationProject.getMediaDefaultSettings();
            if (this.stackComp == null) return;
            int i = 0;
            while (i < this.settingPanels.size()) {
                this.settingPanels.get(i).setDefaultSettings(this.mediaDefaultSettings);
                ++i;
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label interactionSelectorLabel = new Label(comp, 0);
        interactionSelectorLabel.setText("Interaction Type:");
        interactionSelectorLabel.setLayoutData((Object)new GridData());
        this.interactionSelector = new Combo(comp, 12);
        this.interactionSelector.setLayoutData((Object)new GridData());
        this.scrollComp = new ScrolledComposite(comp, 2560);
        this.scrollComp.getVerticalBar().setIncrement(4);
        this.scrollComp.setBackground(parent.getDisplay().getSystemColor(1));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 400;
        this.scrollComp.setLayoutData((Object)gridData);
        this.stack = new StackLayout();
        this.stackComp = new Composite((Composite)this.scrollComp, 0);
        this.stackComp.setBackground(parent.getDisplay().getSystemColor(1));
        this.stackComp.setLayout((Layout)this.stack);
        this.interactionTypes = InteractionTypeManager.getInstance().getInteractionTypes();
        int i = 0;
        while (i < this.interactionTypes.size()) {
            InteractionType interactionType = this.interactionTypes.get(i);
            this.interactionSelector.add(interactionType.getName());
            Composite interactionComp = new Composite(this.stackComp, 0);
            interactionComp.setBackground(parent.getDisplay().getSystemColor(1));
            this.interactionComposites.add(interactionComp);
            interactionComp.setLayout((Layout)new GridLayout(1, false));
            Map panelMap = MediaDefaultsPanelManager.getInstance().getIndexedMediaDefaultsPanels(interactionType.getId());
            for (IMediaDefaultPanel panel : panelMap.values()) {
                Control panelControl = panel.createControls(interactionComp, true);
                panelControl.setLayoutData((Object)new GridData(768));
                this.settingPanels.add(panel);
                if (this.mediaDefaultSettings == null) continue;
                panel.setDefaultSettings(this.mediaDefaultSettings);
            }
            ++i;
        }
        this.interactionSelector.select(0);
        this.stack.topControl = (Control)this.interactionComposites.get(0);
        this.stackComp.layout(true, true);
        this.scrollComp.setContent((Control)this.stackComp);
        this.scrollComp.setMinWidth(this.stackComp.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.scrollComp.setMinHeight(this.stackComp.computeSize((int)-1, (int)-1, (boolean)true).y);
        this.scrollComp.setExpandHorizontal(true);
        this.scrollComp.setExpandVertical(true);
        this.interactionSelector.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                ApplicationProjectMediaDefaultsPropertyPage.this.stack.topControl = (Control)ApplicationProjectMediaDefaultsPropertyPage.this.interactionComposites.get(ApplicationProjectMediaDefaultsPropertyPage.this.interactionSelector.getSelectionIndex());
                ApplicationProjectMediaDefaultsPropertyPage.this.stackComp.layout(true, true);
                Point preferred = ApplicationProjectMediaDefaultsPropertyPage.this.stackComp.computeSize(ApplicationProjectMediaDefaultsPropertyPage.this.scrollComp.getMinWidth(), -1, true);
                ApplicationProjectMediaDefaultsPropertyPage.this.scrollComp.setMinSize(preferred);
                ApplicationProjectMediaDefaultsPropertyPage.this.stackComp.layout();
                if (preferred.y > ApplicationProjectMediaDefaultsPropertyPage.this.scrollComp.getClientArea().height) {
                    preferred = ApplicationProjectMediaDefaultsPropertyPage.this.stackComp.computeSize(ApplicationProjectMediaDefaultsPropertyPage.this.scrollComp.getClientArea().width, -1, true);
                    ApplicationProjectMediaDefaultsPropertyPage.this.scrollComp.setMinSize(preferred);
                    ApplicationProjectMediaDefaultsPropertyPage.this.stackComp.layout();
                }
                ApplicationProjectMediaDefaultsPropertyPage.this.stackComp.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).ApplicationProjectMediaDefaultsPropertyPage.this.stackComp.layout(true, true);
                    }
                });
            }
        });
        return comp;
    }

    public boolean performOk() {
        int i = 0;
        while (i < this.settingPanels.size()) {
            this.settingPanels.get(i).save();
            ++i;
        }
        this.applicationProject.storeMediaDefaultSettings();
        return true;
    }
}

