/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.views.pallet;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.vtp.desktop.views.Activator;
import org.eclipse.vtp.desktop.views.pallet.Pallet;
import org.osgi.framework.Bundle;

public class PalletManager {
    public static String palletExtensionPointId = "org.eclipse.vtp.desktop.views.pallet";
    public static String defaultPalletId = "org.eclipse.vtp.desktop.views.pallet.simple";
    private static PalletManager instance = new PalletManager();
    private Map<String, PalletRecord> primitiveTypes = new HashMap<String, PalletRecord>();

    public static PalletManager getDefault() {
        return instance;
    }

    public PalletManager() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(palletExtensionPointId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            String id = primitiveExtensions[i].getAttribute("id");
            String name = primitiveExtensions[i].getAttribute("name");
            String className = primitiveExtensions[i].getAttribute("class");
            Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
            try {
                Class providerClass = contributor.loadClass(className);
                PalletRecord palletRecord = new PalletRecord();
                palletRecord.id = id;
                palletRecord.name = name;
                palletRecord.clazz = providerClass;
                this.primitiveTypes.put(id, palletRecord);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public List<PalletRecord> getInstalledPallets() {
        LinkedList<PalletRecord> ret = new LinkedList<PalletRecord>();
        ret.addAll(this.primitiveTypes.values());
        return ret;
    }

    public String getCurrentPallet() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String palletId = store.getString("CurrentPallet");
        if (palletId == null) {
            return defaultPalletId;
        }
        return palletId;
    }

    public Pallet createDefaultPallet() {
        try {
            return this.primitiveTypes.get((Object)PalletManager.defaultPalletId).clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Pallet createCurrentPallet() {
        try {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            String palletId = store.getString("CurrentPallet");
            PalletRecord palletRecord = this.primitiveTypes.get(palletId);
            if (palletRecord == null) {
                return this.createDefaultPallet();
            }
            return palletRecord.clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.createDefaultPallet();
        }
    }

    public class PalletRecord {
        String id;
        String name;
        Class<Pallet> clazz;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Class<Pallet> getPalletClass() {
            return this.clazz;
        }
    }
}

