/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.views.pallet;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.views.pallet.PallateProviderManager;
import org.eclipse.vtp.desktop.views.pallet.Pallet;
import org.eclipse.vtp.desktop.views.pallet.PalletItem;
import org.eclipse.vtp.desktop.views.pallet.PalletItemObserver;
import org.eclipse.vtp.desktop.views.pallet.PalletItemProvider;
import org.eclipse.vtp.desktop.views.pallet.PalletItemTransfer;

public class SimplePallet
implements Pallet {
    private static final Comparator<PalletItemProvider> PALLATE_ITEM_PROVIDER_SORT = new Comparator<PalletItemProvider>(){

        @Override
        public int compare(PalletItemProvider left, PalletItemProvider right) {
            PalletItemProvider leftProvider = left;
            PalletItemProvider rightProvider = right;
            int diff = leftProvider.getRanking() - rightProvider.getRanking();
            if (diff == 0) {
                diff = leftProvider.getName().compareTo(rightProvider.getName());
            }
            return diff;
        }
    };
    private static final ViewerSorter PALLATE_ITEM_SORT = new ViewerSorter(){

        public int compare(Viewer viewer, Object left, Object right) {
            PalletItem leftItem = (PalletItem)left;
            PalletItem rightItem = (PalletItem)right;
            return leftItem.getName().compareTo(rightItem.getName());
        }
    };
    private IDesign container = null;
    private Map<PalletItemProvider, ProviderSection> sectionsByProvider = Collections.emptyMap();
    private FormToolkit toolkit = null;
    private ScrolledForm form = null;

    @Override
    public void setContainer(IDesign container) {
        this.container = container;
    }

    @Override
    public void createControl(Composite parent) {
        TreeMap<PalletItemProvider, ProviderSection> sectionsByProvider = new TreeMap<PalletItemProvider, ProviderSection>(PALLATE_ITEM_PROVIDER_SORT);
        for (PalletItemProvider provider : PallateProviderManager.getPallateProviders()) {
            int numItems = 0;
            List<PalletItem> items = provider.getPalletItems();
            for (PalletItem item : items) {
                if (!item.canBeContainedBy(this.container)) continue;
                ++numItems;
            }
            if (numItems <= 0) continue;
            sectionsByProvider.put(provider, new ProviderSection(provider));
        }
        this.sectionsByProvider = Collections.unmodifiableMap(sectionsByProvider);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        Composite formBody = this.form.getBody();
        formBody.setLayout((Layout)new GridLayout(1, false));
        int height = 0;
        int width = 0;
        for (ProviderSection ps : this.sectionsByProvider.values()) {
            Control cps = ps.initialize();
            cps.setLayoutData((Object)new GridData(4, 4, true, false));
            Point point = cps.computeSize(-1, -1);
            height += point.y;
            if (point.x <= width) continue;
            width = point.x;
        }
        this.form.setSize(width, height);
        this.form.layout(true, true);
    }

    @Override
    public Control getControl() {
        return this.form;
    }

    @Override
    public void destroy() {
        for (ProviderSection ps : this.sectionsByProvider.values()) {
            ps.destroy();
        }
        this.form.dispose();
        this.form = null;
        this.toolkit.dispose();
        this.toolkit = null;
        this.sectionsByProvider = Collections.emptyMap();
    }

    private final class ProviderSection
    extends LabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider,
    IMenuListener,
    DragSourceListener,
    IExpansionListener,
    PalletItemObserver {
        final PalletItemProvider provider;
        Section section = null;
        TableViewer viewer = null;

        ProviderSection(PalletItemProvider provider) {
            this.provider = provider;
        }

        Control initialize() {
            this.section = SimplePallet.this.toolkit.createSection(SimplePallet.this.form.getBody(), 256);
            this.section.setText(this.provider.getName());
            this.viewer = new TableViewer(SimplePallet.this.toolkit.createTable((Composite)this.section, 0));
            this.viewer.setContentProvider((IContentProvider)this);
            this.viewer.setLabelProvider((IBaseLabelProvider)this);
            this.viewer.setSorter(PALLATE_ITEM_SORT);
            this.viewer.setInput((Object)this.provider);
            this.viewer.addDragSupport(3, new Transfer[]{PalletItemTransfer.getInstance()}, (DragSourceListener)this);
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener((IMenuListener)this);
            this.viewer.getControl().setMenu(menuMgr.createContextMenu(this.viewer.getControl()));
            this.section.setClient(this.viewer.getControl());
            if (this.equals(SimplePallet.this.sectionsByProvider.values().iterator().next())) {
                this.section.setExpanded(true);
            }
            this.section.addExpansionListener((IExpansionListener)this);
            this.provider.addPalletItemObserver(this);
            return this.section;
        }

        void destroy() {
            this.provider.removePalletItemObserver(this);
            this.section.removeExpansionListener((IExpansionListener)this);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            LinkedList<PalletItem> palletItems = new LinkedList<PalletItem>();
            PalletItemProvider provider = (PalletItemProvider)inputElement;
            List<PalletItem> items = provider.getPalletItems();
            for (PalletItem item : items) {
                if (!item.canBeContainedBy(SimplePallet.this.container)) continue;
                palletItems.add(item);
            }
            return palletItems.toArray();
        }

        public void dispose() {
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((PalletItem)element).getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image icon = ((PalletItem)element).getIcon();
            if (icon != null) {
                return icon;
            }
            return Activator.getDefault().getImageRegistry().get("ICON_MODULE");
        }

        public void menuAboutToShow(IMenuManager manager) {
            this.provider.createMenu(null, manager, ((IStructuredSelection)this.viewer.getSelection()).toList().toArray(new PalletItem[0]));
        }

        public void dragStart(DragSourceEvent event) {
            event.doit = true;
            PalletItemTransfer.getInstance().setPalletItem((PalletItem)((IStructuredSelection)this.viewer.getSelection()).getFirstElement());
        }

        public void dragSetData(DragSourceEvent event) {
            if (PalletItemTransfer.getInstance().isSupportedType(event.dataType)) {
                event.data = PalletItemTransfer.getInstance().getPalletItem();
            }
        }

        public void dragFinished(DragSourceEvent event) {
        }

        public void expansionStateChanging(ExpansionEvent e) {
            if (!e.getState()) {
                return;
            }
            for (ProviderSection providerSection : SimplePallet.this.sectionsByProvider.values()) {
                if (providerSection == this || providerSection.section == null) continue;
                providerSection.section.setExpanded(false);
            }
        }

        public void expansionStateChanged(ExpansionEvent e) {
        }

        @Override
        public void palletItemsChanged() {
            try {
                System.err.println("Viewer null? " + Boolean.toString(this.viewer == null));
                if (this.viewer != null) {
                    this.viewer.getTable().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ProviderSection.this.viewer.refresh();
                            SimplePallet.this.form.getBody().layout(true, true);
                            SimplePallet.this.form.reflow(true);
                        }
                    });
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }
}

