/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.actions;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.vtp.framework.common.configurations.DispatchConfiguration;
import org.eclipse.vtp.framework.common.controller.IController;
import org.eclipse.vtp.framework.common.controller.IIncludeDispatcher;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;

public class IncludeAction
implements IAction {
    private final IActionContext context;
    private final IController controller;
    private final DispatchConfiguration configuration;

    public IncludeAction(IActionContext context, IController controller, DispatchConfiguration configuration) {
        this.context = context;
        this.controller = controller;
        this.configuration = configuration;
    }

    public IActionResult execute() {
        String cmd = this.context.getParameter(this.context.getActionID());
        if ("complete".equals(cmd)) {
            String result;
            if (this.context.isReportingEnabled()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("include.target", String.valueOf(this.configuration.getTargetProcessURI()));
                ((Dictionary)props).put("event", "include.after");
                ((Dictionary)props).put("include.result", String.valueOf(this.context.getParameter("exit")));
                this.context.report(3, "Include returned with \"" + this.context.getParameter("exit") + "\".", props);
            }
            if ((result = this.context.getParameter("exit")) == null) {
                result = "default";
            }
            return this.context.createResult(result);
        }
        try {
            if (this.context.isReportingEnabled()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("include.target", String.valueOf(this.configuration.getTargetProcessURI()));
                ((Dictionary)props).put("event", "include.before");
                this.context.report(3, "Including \"" + this.configuration.getTargetProcessURI() + "\".", props);
            }
            IIncludeDispatcher include = this.controller.createInclude(this.configuration);
            include.setParameterValue(this.context.getActionID(), "complete");
            if (include.enqueue()) {
                return this.context.createResult("repeat");
            }
        }
        catch (Exception e) {
            return this.context.createResult("error.include", (Throwable)e);
        }
        return this.context.createResult("error.include");
    }
}

