/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.actions;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.vtp.framework.common.IScriptingEngine;
import org.eclipse.vtp.framework.common.IScriptingService;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.common.ScriptingException;
import org.eclipse.vtp.framework.common.configurations.ScriptConfiguration;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;

public class ScriptedAction
implements IAction {
    private final IActionContext context;
    private final IScriptingEngine engine;
    private final String script;
    private final IVariableRegistry variableRegistry;

    public ScriptedAction(IActionContext context, IScriptingService scriptingService, ScriptConfiguration configuration, IVariableRegistry variableRegistry) {
        this.context = context;
        this.engine = scriptingService.createScriptingEngine(configuration.getScriptingLanguage());
        this.script = configuration.getScript();
        this.variableRegistry = variableRegistry;
    }

    public IActionResult execute() {
        Hashtable<String, String> props;
        if (this.context.isReportingEnabled()) {
            props = new Hashtable<String, String>();
            ((Dictionary)props).put("event", "script.before");
            this.context.report(3, "Executing script.", props);
        }
        if (this.context.isInfoEnabled()) {
            this.context.info("Executing script...");
        }
        try {
            this.engine.execute(this.script);
        }
        catch (ScriptingException e) {
            e.printStackTrace();
            IStringObject titleVar = (IStringObject)this.variableRegistry.createVariable("String");
            titleVar.setValue(e.getTitle());
            this.variableRegistry.setVariable("scriptErrorName", titleVar);
            IStringObject descVar = (IStringObject)this.variableRegistry.createVariable("String");
            descVar.setValue(e.getDescription());
            this.variableRegistry.setVariable("scriptErrorMessage", descVar);
            return this.context.createResult("error.script", (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.context.createResult("error.script", (Throwable)e);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return this.context.createResult("error.script", t);
        }
        if (this.context.isReportingEnabled()) {
            props = new Hashtable();
            ((Dictionary)props).put("event", "script.after");
            this.context.report(3, "Script completed.", props);
        }
        return this.context.createResult("default");
    }
}

