/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.configurations;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.vtp.framework.common.configurations.CommonConstants;
import org.eclipse.vtp.framework.common.configurations.FieldConfiguration;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DataTypeConfiguration
implements IConfiguration,
CommonConstants {
    private String name = "";
    private String primaryField = null;
    private final Set<FieldConfiguration> fields = new HashSet<FieldConfiguration>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public String getPrimaryField() {
        return this.primaryField;
    }

    public void setPrimaryField(String primaryField) {
        this.primaryField = primaryField;
    }

    public FieldConfiguration[] getFields() {
        return this.fields.toArray(new FieldConfiguration[this.fields.size()]);
    }

    public void addField(FieldConfiguration field) {
        if (field == null) {
            return;
        }
        this.fields.add(field);
    }

    public void removeField(FieldConfiguration field) {
        this.fields.remove(field);
    }

    public void load(Element configurationElement) {
        this.name = configurationElement.getAttribute("name");
        this.primaryField = configurationElement.hasAttribute("primary-field") ? configurationElement.getAttribute("primary-field") : null;
        this.fields.clear();
        NodeList list = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/common/configurations", "field");
        int i = 0;
        while (i < list.getLength()) {
            FieldConfiguration field = new FieldConfiguration();
            field.load((Element)list.item(i));
            this.fields.add(field);
            ++i;
        }
    }

    public void save(Element configurationElement) {
        configurationElement.setAttribute("name", this.name);
        if (this.primaryField != null) {
            configurationElement.setAttribute("primary-field", this.primaryField);
        }
        if (!this.fields.isEmpty()) {
            String fieldName = "field";
            String prefix = configurationElement.getPrefix();
            if (prefix != null && prefix.length() > 0) {
                fieldName = String.valueOf(prefix) + ":" + fieldName;
            }
            for (FieldConfiguration field : this.fields) {
                Element fieldElement = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/common/configurations", fieldName);
                field.save(fieldElement);
                configurationElement.appendChild(fieldElement);
            }
        }
    }
}

