/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.configurations;

import org.eclipse.vtp.framework.common.configurations.CommonConstants;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;

public class ScriptConfiguration
implements IConfiguration,
CommonConstants {
    private String scriptingLanguage = "";
    private String script = "";
    private boolean secured = false;

    public String getScriptingLanguage() {
        return this.scriptingLanguage;
    }

    public String getScript() {
        return this.script;
    }

    public void setScriptingLanguage(String scriptingLanguage) {
        this.scriptingLanguage = scriptingLanguage == null ? "" : scriptingLanguage;
    }

    public void setScript(String script) {
        this.script = script == null ? "" : script;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public void load(Element configurationElement) {
        this.scriptingLanguage = configurationElement.getAttribute("scripting-language");
        this.secured = Boolean.parseBoolean(configurationElement.getAttribute("secured"));
        this.script = XMLUtilities.getElementTextDataNoEx((Element)configurationElement, (boolean)true);
        if (this.script == null) {
            this.script = "";
        }
    }

    public void save(Element configurationElement) {
        configurationElement.setAttribute("scripting-language", this.scriptingLanguage);
        configurationElement.appendChild(configurationElement.getOwnerDocument().createTextNode(this.script));
        configurationElement.setAttribute("secured", Boolean.toString(this.secured));
    }
}

